/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.base;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.R;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IFlushMoreView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BaseFlushMoreFragment<T>
extends BaseFragment
implements IFlushMoreView<T> {
    protected BaseQuickAdapter<T, ? extends BaseViewHolder> mAdapter;
    protected RecyclerView vRecyclerView;
    protected SmartRefreshLayout vSmartRefreshLayout;

    protected abstract BaseQuickAdapter<T, ? extends BaseViewHolder> getBaseQuickAdapter();

    @Override
    protected abstract int getLayoutId();

    @Override
    public void init() {
        this.searchView(this.rootView);
    }

    @Override
    public void onInitComplete() {
        this.vRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        this.mAdapter = this.getBaseQuickAdapter();
        this.vRecyclerView.setAdapter(this.mAdapter);
        this.mAdapter.setEnableLoadMore(false);
        this.vSmartRefreshLayout.setOnRefreshListener(refreshlayout -> this.flushOrLoad(false));
        this.mAdapter.setOnLoadMoreListener(() -> this.flushOrLoad(true), this.vRecyclerView);
        this.flushOrLoad(false);
    }

    protected abstract void flushOrLoad(boolean var1);

    private View searchView(View parentView) {
        if (parentView instanceof ViewGroup) {
            int childCount = ((ViewGroup)parentView).getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View childView = ((ViewGroup)parentView).getChildAt(i);
                if (childView instanceof RecyclerView) {
                    this.vRecyclerView = (RecyclerView)childView;
                }
                if (childView instanceof SmartRefreshLayout) {
                    this.vSmartRefreshLayout = (SmartRefreshLayout)childView;
                }
                this.searchView(childView);
            }
        } else {
            return parentView;
        }
        return null;
    }

    @Override
    public void bindData(List<T> pageData) {
        if (this.mAdapter == null) {
            this.mAdapter = this.getBaseQuickAdapter();
        } else if (pageData != null) {
            this.mAdapter.setNewData(pageData);
        }
        this.mAdapter.setEnableLoadMore(false);
        if (pageData != null && pageData.size() == 10) {
            this.mAdapter.setEnableLoadMore(true);
        }
        this.vSmartRefreshLayout.finishRefresh();
    }

    @Override
    @NotNull
    public Context injectContext() {
        return this.mContext;
    }

    public void finishCurrentView() {
        this.pop();
    }

    @Override
    public void addMore(List<T> pageData) {
        if (this.mAdapter == null) {
            this.mAdapter = this.getBaseQuickAdapter();
        }
        if (pageData.size() < 10) {
            this.mAdapter.setEnableLoadMore(false);
        }
        this.mAdapter.addData(pageData);
        this.mAdapter.loadMoreComplete();
    }

    @Override
    public void noMore() {
        if (this.mAdapter == null) {
            this.mAdapter = this.getBaseQuickAdapter();
        }
        this.mAdapter.loadMoreEnd();
        this.vSmartRefreshLayout.finishLoadmore();
    }

    @NotNull
    public View getVToolView() {
        return this.rootView.findViewById(R.id.vToolBar);
    }

    @Override
    public void noData() {
        this.mAdapter.setNewData(null);
        this.vSmartRefreshLayout.finishRefresh();
    }
}

