/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.util;

import android.app.Application;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.blankj.utilcode.util.Utils;
import com.kangxin.common.R;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/kangxin/common/byh/util/NotifyUtil;", "", "()V", "showNotifyMsg", "", "intent", "Landroid/app/PendingIntent;", "contentText", "", "title", "module_common_release"})
public final class NotifyUtil {
    public static final NotifyUtil INSTANCE;

    public final void showNotifyMsg(@NotNull PendingIntent intent, @Nullable String contentText, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Object object = Utils.getApp().getSystemService("notification");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = null;
            channel = new NotificationChannel("default", (CharSequence)contentText, 3);
            channel.enableLights(true);
            channel.setLightColor(-65536);
            channel.setShowBadge(true);
            channel.canShowBadge();
            channel.setBypassDnd(true);
            channel.setDescription("\u901a\u77e5");
            channel.enableVibration(true);
            channel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
            notificationManager.createNotificationChannel(channel);
        }
        NotificationCompat.Builder build2 = new NotificationCompat.Builder((Context)Utils.getApp(), "default");
        build2.setContentTitle((CharSequence)title);
        build2.setContentText((CharSequence)contentText);
        build2.setNumber(3);
        build2.setTicker((CharSequence)contentText);
        build2.setWhen(System.currentTimeMillis());
        build2.setPriority(0);
        build2.setAutoCancel(true);
        build2.setOngoing(false);
        build2.setDefaults(2);
        build2.setSmallIcon(R.mipmap.ic_launcher);
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"Utils.getApp()");
        build2.setLargeIcon(BitmapFactory.decodeResource((Resources)application.getResources(), (int)R.mipmap.ic_launcher));
        build2.setContentIntent(intent);
        Notification mNotification = build2.build();
        notificationManager.notify((int)new Date().getTime(), mNotification);
    }

    private NotifyUtil() {
    }

    static {
        NotifyUtil notifyUtil;
        INSTANCE = notifyUtil = new NotifyUtil();
    }
}

