/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.R;
import com.kangxin.common.byh.widget.DefaultEmptyPage;
import com.kangxin.common.widget.RecyclerViewCache;
import java.util.ArrayList;
import java.util.List;

public class DefEmptyPageProxy {
    private static final String TAG = "DefEmptyPageProxy";
    private static DefEmptyPageProxy INSTANCE;
    private Context mContext;
    private DefaultEmptyPage mDefEmptyPage;
    private DefaultEmptyPage.OnDefpageClickListener onDefpageClickListener;
    private List<DefEmptyType> defEmptyTypes = new ArrayList<DefEmptyType>();
    private List<DefaultEmptyPage.OnDefpageClickListener> onDefpageClickListenerList = new ArrayList<DefaultEmptyPage.OnDefpageClickListener>();

    private DefEmptyPageProxy(Context context) {
        this.mContext = context;
    }

    public static DefEmptyPageProxy getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new DefEmptyPageProxy(context);
        }
        return INSTANCE;
    }

    public void putClickListener(DefaultEmptyPage.OnDefpageClickListener defpageClickListener) {
        if (defpageClickListener != null) {
            this.onDefpageClickListenerList.add(defpageClickListener);
        }
    }

    public void removeClickListener(DefaultEmptyPage.OnDefpageClickListener defpageClickListener) {
        if (defpageClickListener != null) {
            this.onDefpageClickListenerList.remove(defpageClickListener);
        }
    }

    public DefaultEmptyPage.OnDefpageClickListener getDefEmptyListener() {
        if (this.onDefpageClickListenerList.size() > 0) {
            return this.onDefpageClickListenerList.get(this.onDefpageClickListenerList.size() - 1);
        }
        return null;
    }

    public void putDefEmptyType(DefEmptyType defEmptyType) {
        if (defEmptyType != null) {
            this.defEmptyTypes.add(defEmptyType);
        }
    }

    public void removeDefEmptyType(DefEmptyType defEmptyType) {
        if (defEmptyType != null) {
            this.defEmptyTypes.remove((Object)defEmptyType);
        }
    }

    public DefEmptyType getDefEmptyType() {
        if (this.defEmptyTypes.size() > 0) {
            return this.defEmptyTypes.get(this.defEmptyTypes.size() - 1);
        }
        return null;
    }

    public void loadDefEmptyPage() {
        ViewGroup viewGroup = RecyclerViewCache.getInstance().getRecyclerView();
        if (viewGroup instanceof RecyclerView) {
            RecyclerView recyclerView = (RecyclerView)viewGroup;
            RecyclerView.Adapter adapter = recyclerView.getAdapter();
            if (adapter instanceof BaseQuickAdapter) {
                List dataList = ((BaseQuickAdapter)adapter).getData();
                Log.i((String)TAG, (String)("loadDefEmptyPage: dataList:" + dataList));
                DefEmptyType defEmptyType = this.getDefEmptyType();
                this.setOnDefpageClickListener(this.getDefEmptyListener());
                if (defEmptyType != null) {
                    this.createDefEmptyPage(dataList, viewGroup, defEmptyType);
                } else {
                    this.createDefEmptyPage(dataList, viewGroup, DefEmptyType.NO_RECORDS);
                }
            } else {
                Log.i((String)TAG, (String)"loadDefEmptyPage: \u4e0d\u662fBaseQuickAdapter");
            }
        } else {
            Log.i((String)TAG, (String)"loadDefEmptyPage: \u4e0d\u662fRecyclerView\u7684\u60c5\u51b5");
        }
    }

    public <T> void createDefEmptyPage(ViewGroup busGroupView, DefEmptyType defEmptyType) {
        this.createDefEmptyPage(null, busGroupView, defEmptyType);
    }

    public <T> void createDefEmptyPage(List<T> dataList, ViewGroup busGroupView, DefEmptyType defEmptyType) {
        boolean isShowBtn = true;
        if (this.onDefpageClickListener == null && this.onDefpageClickListenerList.isEmpty()) {
            isShowBtn = false;
        }
        switch (defEmptyType) {
            case NO_RECORDS: {
                this.mDefEmptyPage = new DefaultEmptyPage.Builder(this.mContext).setBusViewGroup(busGroupView).setDataList(dataList).setOnDefpageClickListener(this.onDefpageClickListener).showBtn(isShowBtn).create();
                break;
            }
            case NO_PAGE: {
                this.mDefEmptyPage = new DefaultEmptyPage.Builder(this.mContext).setBusViewGroup(busGroupView).setDataList(dataList).setOnDefpageClickListener(this.onDefpageClickListener).setDefImgid(R.drawable.ic_defnopage_img).setDefDescText(this.getString(R.string.commbyh_zanwuyem)).setDefEngText(this.getString(R.string.commbyh_zanwuyem_eng)).setDefBtnText(this.getString(R.string.commbyh_wozhidle)).showBtn(isShowBtn).create();
                break;
            }
            case NO_SEARCH_RESULT: {
                this.mDefEmptyPage = new DefaultEmptyPage.Builder(this.mContext).setBusViewGroup(busGroupView).setDataList(dataList).setOnDefpageClickListener(this.onDefpageClickListener).setDefImgid(R.drawable.ic_defnosearch_img).setDefDescText(this.getString(R.string.commbyh_nosearch_result)).setDefEngText(this.getString(R.string.commbyh_nosearch_result_eng)).setDefBtnText(this.getString(R.string.commbyh_wozhidle)).showBtn(isShowBtn).create();
                break;
            }
            case NET_EXCEPTION: {
                this.mDefEmptyPage = new DefaultEmptyPage.Builder(this.mContext).setBusViewGroup(busGroupView).setDataList(dataList).setOnDefpageClickListener(this.onDefpageClickListener).setDefImgid(R.drawable.ic_defnet_exception).setDefDescText(this.getString(R.string.comm_net_exception)).setDefEngText(this.getString(R.string.comm_net_exception_eng)).setDefBtnText(this.getString(R.string.comm_check_net)).showBtn(isShowBtn).create();
                break;
            }
            case NO_GROUP_CHATS: {
                this.mDefEmptyPage = new DefaultEmptyPage.Builder(this.mContext).setBusViewGroup(busGroupView).setDataList(dataList).setOnDefpageClickListener(this.onDefpageClickListener).setDefImgid(R.drawable.ic_defno_groupchat).setDefDescText(this.getString(R.string.byhim_commbyh_def_nochatgroupdesc)).setDefEngText(this.getString(R.string.byhim_commbyh_def_nochatgroupdesc_eng)).setDefBtnText(this.getString(R.string.byhim_start_groupchat)).showBtn(isShowBtn).create();
                break;
            }
            case NO_HEALTH_MANAGERS: {
                this.mDefEmptyPage = new DefaultEmptyPage.Builder(this.mContext).setBusViewGroup(busGroupView).setDataList(dataList).setOnDefpageClickListener(this.onDefpageClickListener).setDefImgid(R.drawable.ic_defno_health_manager).setDefDescText(this.getString(R.string.comm_no_health_manager)).setDefEngText(this.getString(R.string.comm_no_health_manager_eng)).setDefBtnText(this.getString(R.string.comm_make_healthmanager_plan)).showBtn(isShowBtn).create();
                break;
            }
            case NO_AUTH: {
                this.mDefEmptyPage = new DefaultEmptyPage.Builder(this.mContext).setBusViewGroup(busGroupView).setDataList(dataList).setOnDefpageClickListener(this.onDefpageClickListener).setDefImgid(R.drawable.ic_defpage_no_auth).setDefDescText(this.getString(R.string.comm_no_auth)).setDefEngText(this.getString(R.string.comm_no_auth_eng)).setDefBtnText(this.getString(R.string.comm_open_auth)).showBtn(isShowBtn).create();
            }
        }
    }

    public void showNetErrPage() {
        ViewGroup viewGroup = RecyclerViewCache.getInstance().getRecyclerView();
        if (viewGroup != null) {
            this.setOnDefpageClickListener(new DefaultEmptyPage.OnDefpageClickListener(){

                @Override
                public void onClickDefbtn(View view) {
                    Intent intent = new Intent("android.settings.WIFI_SETTINGS");
                    intent.addFlags(0x10000000);
                    DefEmptyPageProxy.this.mContext.startActivity(intent);
                }
            });
            this.createDefEmptyPage(viewGroup, DefEmptyType.NET_EXCEPTION);
        }
    }

    public void showDefPage(boolean isShow) {
        if (this.mDefEmptyPage != null) {
            this.mDefEmptyPage.showDef(isShow);
        }
    }

    public void setOnDefpageClickListener(DefaultEmptyPage.OnDefpageClickListener onDefpageClickListener) {
        this.onDefpageClickListener = onDefpageClickListener;
    }

    private String getString(int id2) {
        return this.mContext.getString(id2);
    }

    public static enum DefEmptyType {
        NO_RECORDS,
        NO_PAGE,
        NO_SEARCH_RESULT,
        NET_EXCEPTION,
        NO_GROUP_CHATS,
        NO_HEALTH_MANAGERS,
        NO_AUTH;

    }
}

