/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.framework;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.fragment.app.Fragment;
import com.kangxin.common.framework.ImageSelector;
import com.kangxin.common.framework.photoSelect.GlideCacheEngine;
import com.kangxin.common.framework.photoSelect.GlideEngine;
import com.luck.picture.lib.PictureSelectionModel;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.engine.CacheResourcesEngine;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnResultCallbackListener;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectorImpl
implements ImageSelector {
    private static final String TAG = "PictureSelectorImpl";
    private static final int MAX_SELNUM = 9;
    private static final int MIX_SELNUM = 1;
    private static final int COLUM_SHOWNUM = 4;
    private static final int CLIP_OUTQUALITY = 90;
    private static final int MINI_COMPSIZE = 100;
    private PictureSelectionModel mPicSelector;

    @Override
    public void init(Activity activity) {
        this.mPicSelector = PictureSelector.create((Activity)activity).openGallery(PictureMimeType.ofImage()).loadImageEngine((ImageEngine)GlideEngine.createGlideEngine()).loadCacheResourcesCallback((CacheResourcesEngine)GlideCacheEngine.createCacheEngine()).maxSelectNum(9).minSelectNum(1).imageSpanCount(4).isReturnEmpty(false).setRequestedOrientation(-1).isSingleDirectReturn(true).previewVideo(true).isCamera(false).isZoomAnim(true).enableCrop(true).compress(true).synOrAsy(true).cutOutQuality(90).minimumCompressSize(100);
    }

    @Override
    public void init(Fragment fragment) {
        this.mPicSelector = PictureSelector.create((Fragment)fragment).openGallery(PictureMimeType.ofImage()).loadImageEngine((ImageEngine)GlideEngine.createGlideEngine()).loadCacheResourcesCallback((CacheResourcesEngine)GlideCacheEngine.createCacheEngine()).maxSelectNum(9).minSelectNum(1).imageSpanCount(4).isReturnEmpty(false).setRequestedOrientation(-1).isSingleDirectReturn(true).previewVideo(true).isCamera(false).isZoomAnim(true).enableCrop(false).compress(true).synOrAsy(true).cutOutQuality(90).minimumCompressSize(100);
    }

    @Override
    public void init(Context context) {
    }

    @Override
    @Deprecated
    public void openCameraSingle(ImageSelector.OnImageSelectedListener listener2) {
    }

    @Override
    public void openCamera(Activity activity, final ImageSelector.OnImageSelectedListener listener2) {
        PictureSelector.create((Activity)activity).openCamera(PictureMimeType.ofImage()).loadImageEngine((ImageEngine)GlideEngine.createGlideEngine()).compress(true).forResult((OnResultCallbackListener)new OnResultCallbackListener<LocalMedia>(){

            public void onResult(List<LocalMedia> result) {
                if (result != null && result.size() > 0 && listener2 != null) {
                    listener2.onSelectedImages(result.get(0).getCompressPath());
                }
            }

            public void onCancel() {
            }
        });
    }

    @Override
    public void openCamera(Fragment fragment, final ImageSelector.OnImageSelectedListener listener2) {
        PictureSelector.create((Fragment)fragment).openCamera(PictureMimeType.ofImage()).loadImageEngine((ImageEngine)GlideEngine.createGlideEngine()).compress(true).forResult((OnResultCallbackListener)new OnResultCallbackListener<LocalMedia>(){

            public void onResult(List<LocalMedia> result) {
                if (result != null && result.size() > 0 && listener2 != null) {
                    listener2.onSelectedImages(result.get(0).getCompressPath());
                }
            }

            public void onCancel() {
            }
        });
    }

    @Override
    public void openAlbumSingle(final ImageSelector.OnImageSelectedListener listener2) {
        if (this.mPicSelector == null) {
            return;
        }
        this.mPicSelector.selectionMode(1);
        this.mPicSelector.forResult((OnResultCallbackListener)new OnResultCallbackListener<LocalMedia>(){

            public void onResult(List<LocalMedia> result) {
                ArrayList<String> pathList = new ArrayList<String>();
                for (LocalMedia media : result) {
                    if (media.getCompressPath() == null) continue;
                    pathList.add(media.getCompressPath());
                }
                if (listener2 != null && !pathList.isEmpty()) {
                    listener2.onSelectedImages((String)pathList.get(0));
                }
            }

            public void onCancel() {
                Log.i((String)PictureSelectorImpl.TAG, (String)"PictureSelector Cancel");
            }
        });
    }

    @Override
    public void openAlbumMany(final ImageSelector.OnImagesSelectedListener listener2) {
        if (this.mPicSelector == null) {
            return;
        }
        this.mPicSelector.selectionMode(2);
        this.mPicSelector.forResult((OnResultCallbackListener)new OnResultCallbackListener<LocalMedia>(){

            public void onResult(List<LocalMedia> result) {
                ArrayList<String> pathList = new ArrayList<String>();
                for (LocalMedia media : result) {
                    if (media.getCompressPath() == null) continue;
                    pathList.add(media.getCompressPath());
                }
                if (listener2 != null && !pathList.isEmpty()) {
                    listener2.onSelectedImages(pathList);
                }
            }

            public void onCancel() {
                Log.i((String)PictureSelectorImpl.TAG, (String)"PictureSelector Cancel");
            }
        });
    }
}

