/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.guide.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import com.kangxin.common.guide.util.LogUtil;

public class ScreenUtils {
    private ScreenUtils() {
        throw new AssertionError();
    }

    public static int dp2px(Context context, int dp) {
        return (int)((float)dp * context.getResources().getDisplayMetrics().density);
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return dm.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return dm.heightPixels;
    }

    public static int getStatusBarHeight(Context context) {
        int height = ScreenUtils.dp2px(context, 20);
        LogUtil.i("common statusBar height:" + height);
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            height = context.getResources().getDimensionPixelSize(resourceId);
            LogUtil.i("real statusBar height:" + height);
        }
        LogUtil.i("finally statusBar height:" + height);
        return height;
    }

    public static boolean isNavigationBarShow(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17) {
            Display display = activity.getWindowManager().getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getSize(size);
            display.getRealSize(realSize);
            return realSize.y != size.y;
        }
        boolean menu = ViewConfiguration.get((Context)activity).hasPermanentMenuKey();
        boolean back = KeyCharacterMap.deviceHasKey((int)4);
        return !menu && !back;
    }

    public static int getNavigationBarHeight(Activity activity) {
        if (!ScreenUtils.isNavigationBarShow(activity)) {
            return 0;
        }
        int height = 0;
        Resources resources = activity.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            height = resources.getDimensionPixelSize(resourceId);
        }
        LogUtil.i("NavigationBar\u7684\u9ad8\u5ea6:" + height);
        return height;
    }
}

