/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.rx;

import android.accounts.NetworkErrorException;
import android.content.Context;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import com.google.gson.JsonParseException;
import com.kangxin.common.R;
import com.kangxin.common.byh.widget.DefEmptyPageProxy;
import com.kangxin.common.global.ErrorCode;
import com.kangxin.common.util.GlobeLoadingHelper;
import com.kangxin.common.util.StringsUtils;
import io.reactivex.observers.DefaultObserver;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import retrofit2.HttpException;

public abstract class ProgressDialogObserver<T>
extends DefaultObserver<T> {
    private static final String TAG = "ProgressDialogObserver";
    final String MSG = StringsUtils.getString(R.string.common_lianxikaifarenyuanjiejuewenti_cuowuma);
    String msg = "";
    private Context mContext = this.attachContext();

    protected void onStart() {
        Log.i((String)"ProgressDialog", (String)("onstart " + Thread.currentThread().getName()));
        this.onComplete();
        GlobeLoadingHelper.show(this.mContext);
    }

    public abstract void onNext(T var1);

    public void onError(Throwable t) {
        Log.i((String)"ProgressDialog", (String)("onerror " + Thread.currentThread().getName()));
        t.printStackTrace();
        GlobeLoadingHelper.dissmiss();
        if (t instanceof SocketTimeoutException) {
            this.msg = this.MSG + ErrorCode.INSTANCE.getSOCKET_TIME_OUT_ERROR();
        } else if (t instanceof NetworkErrorException || t instanceof HttpException) {
            this.msg = this.MSG + ErrorCode.INSTANCE.getNET_ERROR();
        } else if (t instanceof JsonParseException) {
            this.msg = this.MSG + ErrorCode.INSTANCE.getJSON_PARSE_ERROR();
        } else if (t instanceof NullPointerException) {
            this.msg = this.MSG + ErrorCode.INSTANCE.getNULL_POINT_ERROR();
        } else if (t instanceof ArrayIndexOutOfBoundsException) {
            this.msg = this.MSG + ErrorCode.INSTANCE.getARRAY_INDEX_OUT_ERROR();
        } else if (t instanceof UnknownHostException) {
            this.msg = StringsUtils.getString(R.string.common_qingjianchawangluolianjieshifoukeyong);
            DefEmptyPageProxy.getInstance((Context)Utils.getApp()).showNetErrPage();
        } else {
            this.msg = this.MSG + ErrorCode.INSTANCE.getNO_KNOW_ERROR();
        }
        GlobeLoadingHelper.dissmiss();
    }

    public void onComplete() {
        Log.i((String)"ProgressDialog", (String)("onstart " + Thread.currentThread().getName()));
        DefEmptyPageProxy.getInstance((Context)Utils.getApp()).loadDefEmptyPage();
        GlobeLoadingHelper.dissmiss();
    }

    protected abstract Context attachContext();
}

