/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.kangxin.common.Pretty;
import com.kangxin.common.R;
import com.kangxin.common.base.DynamicImageActivity;
import java.util.ArrayList;
import java.util.List;

public class DynamicImageView
extends FrameLayout {
    private ImageView topLeft;
    private ImageView topRight;
    private ImageView bottomLeft;
    private ImageView bottomRight;
    private TextView countView;
    private ArrayList<String> images = new ArrayList();

    public DynamicImageView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public DynamicImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DynamicImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.addView(DynamicImageView.inflate((Context)this.getContext(), (int)R.layout.inc_commbyh_layout_dynamic_image, null));
        this.topLeft = (ImageView)this.findViewById(R.id.dynamicImageTopLeft);
        this.topRight = (ImageView)this.findViewById(R.id.dynamicImageTopRight);
        this.bottomLeft = (ImageView)this.findViewById(R.id.dynamicImageBottomLeft);
        this.bottomRight = (ImageView)this.findViewById(R.id.dynamicImageBottomRight);
        this.countView = (TextView)this.findViewById(R.id.dynamicImageCount);
        this.setOnClickListener(v -> DynamicImageActivity.start(this.images));
    }

    public void updateImage(List<String> images) {
        this.images.clear();
        this.images.addAll(images);
        this.update();
    }

    private void update() {
        int size = this.images.size();
        if (size == 1) {
            this.topRight.setVisibility(8);
            this.bottomLeft.setVisibility(8);
            this.bottomRight.setVisibility(8);
            this.updateImage(this.images.get(0), this.topLeft);
        } else if (size == 2) {
            this.bottomLeft.setVisibility(8);
            this.bottomRight.setVisibility(8);
            this.updateImage(this.images.get(0), this.topLeft);
            this.updateImage(this.images.get(1), this.topRight);
        } else if (size == 3) {
            this.bottomRight.setVisibility(8);
            this.updateImage(this.images.get(0), this.topLeft);
            this.updateImage(this.images.get(1), this.topRight);
            this.updateImage(this.images.get(2), this.bottomLeft);
        } else {
            this.updateImage(this.images.get(0), this.topLeft);
            this.updateImage(this.images.get(1), this.topRight);
            this.updateImage(this.images.get(2), this.bottomLeft);
            this.updateImage(this.images.get(3), this.bottomRight);
        }
        this.countView.setText((CharSequence)String.format("\u5171 %s \u5f20", size));
    }

    private void updateImage(String url, ImageView imageView) {
        Pretty.create().loadImage(url).centerCrop().into(imageView);
    }
}

