/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.widget.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kangxin.common.R;

public class PlaceHolderRelativeLayout
extends RelativeLayout {
    private View mPlaceView;
    private TextView mPlaceBtnView;
    private static final Integer PLACE_VIEW_TAG = 272;

    public View getPlaceView() {
        return this.mPlaceView;
    }

    public TextView getPlaceBtnView() {
        return this.mPlaceBtnView;
    }

    public PlaceHolderRelativeLayout(Context context) {
        this(context, null);
    }

    public PlaceHolderRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PlaceHolderRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPlaceView = LayoutInflater.from((Context)context).inflate(R.layout.commbyh_list_empty_place2, (ViewGroup)this, false);
        this.mPlaceView.setTag((Object)PLACE_VIEW_TAG);
        this.mPlaceView.setVisibility(8);
        this.addView(this.mPlaceView);
        ImageView placeImgView = (ImageView)this.findViewById(R.id.place_img);
        TextView placeDescView = (TextView)this.findViewById(R.id.place_seat_desc);
        TextView placeDescEngView = (TextView)this.findViewById(R.id.place_seat_desc2);
        this.mPlaceBtnView = (TextView)this.findViewById(R.id.def_page_btn);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PlaceHolderRelativeLayout);
        int placeImg = typedArray.getResourceId(R.styleable.PlaceHolderRelativeLayout_place_img, 0);
        String placeDesc = typedArray.getString(R.styleable.PlaceHolderRelativeLayout_place_desc);
        String placeDescEng = typedArray.getString(R.styleable.PlaceHolderRelativeLayout_place_desc_eng);
        boolean isShowBtn = typedArray.getBoolean(R.styleable.PlaceHolderRelativeLayout_place_showbtn, false);
        if (placeImg != 0) {
            placeImgView.setImageResource(placeImg);
        }
        if (placeDesc != null) {
            placeDescView.setText((CharSequence)placeDesc);
        }
        if (placeDescEng != null) {
            placeDescEngView.setText((CharSequence)placeDescEng);
        }
        if (isShowBtn) {
            this.mPlaceBtnView.setVisibility(0);
        } else {
            this.mPlaceBtnView.setVisibility(8);
        }
        typedArray.recycle();
    }

    public void showPlaceView() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            Object viewTag = childView.getTag();
            if (viewTag != null && viewTag == PLACE_VIEW_TAG) {
                childView.setVisibility(0);
                continue;
            }
            childView.setVisibility(8);
        }
    }

    public void hidePlaceView() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            Object viewTag = childView.getTag();
            if (viewTag != null && viewTag == PLACE_VIEW_TAG) {
                childView.setVisibility(8);
                continue;
            }
            childView.setVisibility(0);
        }
    }
}

