/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.dialog;

import android.content.Context;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

public class CenterHintDialog {
    private Context mContext;
    private String title;
    private String rightText = StringsUtils.getString(R.string.worktab_quxiazai);
    private String leftText = StringsUtils.getString(R.string.worktab_quxiao);
    private String message;
    private View.OnClickListener clickCancel;
    private View.OnClickListener clickOk;
    private Boolean touchOutCancel = true;
    private boolean isShowCancel = true;

    CenterHintDialog(Context mContext) {
        this.mContext = mContext;
    }

    public static CenterHintDialog with(Context mContext) {
        return new CenterHintDialog(mContext);
    }

    public CenterHintDialog setTitle(String title) {
        this.title = title;
        return this;
    }

    public CenterHintDialog setRightText(String rightText) {
        this.rightText = rightText;
        return this;
    }

    public CenterHintDialog setMesssage(String message) {
        this.message = message;
        return this;
    }

    public CenterHintDialog bindCancelClick(View.OnClickListener onClickListener) {
        this.clickCancel = onClickListener;
        return this;
    }

    public CenterHintDialog bindOkClick(View.OnClickListener onClickListener) {
        this.clickOk = onClickListener;
        return this;
    }

    public CenterHintDialog setShowCancel(boolean isShowCancel) {
        this.isShowCancel = isShowCancel;
        return this;
    }

    public CenterHintDialog setLeftText(String leftText) {
        this.leftText = leftText;
        return this;
    }

    public CenterHintDialog touchOutCancel(boolean isTouchCancel) {
        this.touchOutCancel = isTouchCancel;
        return this;
    }

    public void show() {
        String left1 = "     ";
        final AlertDialog alertDialog = new AlertDialog.Builder(this.mContext, R.style.worktab_AlertDialogStyle).create();
        View rootView = View.inflate((Context)this.mContext, (int)R.layout.module_dialog_common_hint, null);
        Window dialogWindow = alertDialog.getWindow();
        WindowManager m = (WindowManager)this.mContext.getSystemService("window");
        Display d = m.getDefaultDisplay();
        WindowManager.LayoutParams p = dialogWindow.getAttributes();
        p.width = (int)((double)d.getWidth() * 0.9);
        p.height = -2;
        dialogWindow.setGravity(17);
        TextView tipsContent = (TextView)rootView.findViewById(R.id.tips_content);
        TextView tipsTitle = (TextView)rootView.findViewById(R.id.tips_title);
        if (this.message.length() < 10) {
            String content = left1 + this.message + left1;
            tipsContent.setText((CharSequence)content);
        } else {
            tipsContent.setText((CharSequence)this.message);
        }
        tipsTitle.setText((CharSequence)this.title);
        TextView mOkBtnView = (TextView)rootView.findViewById(R.id.mOkBtnView);
        mOkBtnView.setText((CharSequence)this.rightText);
        TextView mSignView = (TextView)rootView.findViewById(R.id.mSignView);
        mSignView.setText((CharSequence)this.leftText);
        if (this.isShowCancel) {
            mSignView.setVisibility(0);
        } else {
            mSignView.setVisibility(8);
        }
        mOkBtnView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.dismiss();
                if (CenterHintDialog.this.clickOk != null) {
                    CenterHintDialog.this.clickOk.onClick(v);
                }
            }
        });
        mSignView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.dismiss();
                if (CenterHintDialog.this.clickCancel != null) {
                    CenterHintDialog.this.clickCancel.onClick(v);
                }
            }
        });
        alertDialog.setCanceledOnTouchOutside(this.touchOutCancel.booleanValue());
        alertDialog.setView(rootView);
        alertDialog.show();
        dialogWindow.setAttributes(p);
    }
}

