/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.worktable.widget.WheelListView;
import java.util.List;

public class WheelDialog
extends Dialog {
    private WheelListView wl_wheelView;
    private TextView tv_cancel;
    private TextView tv_success;
    private TextView tv_title;
    private String title = StringsUtils.getString(R.string.worktab_qingxuanzexueli);
    private OnWheelSelectListener listener;

    @SuppressLint(value={"PrivateResource"})
    public WheelDialog(@NonNull Context context) {
        super(context, R.style.Base_Theme_AppCompat_Dialog);
        this.initView(context);
        this.initListener();
    }

    @SuppressLint(value={"PrivateResource"})
    public WheelDialog(@NonNull Context context, String title) {
        super(context, R.style.Base_Theme_AppCompat_Dialog);
        this.title = title;
        this.initView(context);
        this.initListener();
    }

    private void initView(Context context) {
        View rootView = View.inflate((Context)this.getContext(), (int)R.layout.worktab_by_dialog_widget_wheel, null);
        this.wl_wheelView = (WheelListView)rootView.findViewById(R.id.wl_wheelView);
        this.tv_cancel = (TextView)rootView.findViewById(R.id.tv_cancel);
        this.tv_success = (TextView)rootView.findViewById(R.id.tv_success);
        this.tv_title = (TextView)rootView.findViewById(R.id.tv_title);
        this.tv_title.setText((CharSequence)this.title);
        this.setContentView(rootView);
        Window window = this.getWindow();
        final FrameLayout centerArea = (FrameLayout)rootView.findViewById(R.id.centerArea);
        this.wl_wheelView.post(new Runnable(){

            @Override
            public void run() {
                int height = WheelDialog.this.wl_wheelView.getChildAt(0).getMeasuredHeight();
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)centerArea.getLayoutParams();
                params.height = height;
                centerArea.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        });
        if (window != null) {
            window.setBackgroundDrawable((Drawable)new ColorDrawable(Color.argb((int)0, (int)0, (int)0, (int)0)));
            WindowManager.LayoutParams params = window.getAttributes();
            params.gravity = 81;
            WindowManager manager = (WindowManager)context.getSystemService("window");
            window.getDecorView().setPadding(0, 0, 0, 0);
            DisplayMetrics dm = new DisplayMetrics();
            manager.getDefaultDisplay().getMetrics(dm);
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.width = -1;
            lp.height = -2;
            window.setAttributes(lp);
        }
    }

    private void initListener() {
        this.tv_cancel.setOnClickListener(v -> this.dismiss());
        this.tv_success.setOnClickListener(v -> {
            String selectLabel = this.wl_wheelView.getSelectLabel();
            if (this.listener != null) {
                this.listener.onClickOk(this.wl_wheelView.getSelectIndex(), selectLabel);
            }
        });
    }

    public void setLabels(List<String> labels) {
        this.wl_wheelView.setLabels(labels);
    }

    public void setOnWheelSelectListener(OnWheelSelectListener listener2) {
        this.listener = listener2;
    }

    public static interface OnWheelSelectListener {
        public void onClickOk(int var1, String var2);
    }
}

