/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.utils;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Process;
import android.util.Log;
import java.lang.reflect.Method;
import java.util.List;

public class AppUtils {
    public static synchronized String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized Bitmap getAppIcon(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        Drawable d = packageManager.getApplicationIcon(applicationInfo);
        BitmapDrawable bd = (BitmapDrawable)d;
        Bitmap bm = bd.getBitmap();
        return bm;
    }

    public static boolean isRunBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        String packageName = context.getPackageName();
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(packageName) || appProcess.importance != 100) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllowed(Context context, String packageName) {
        AppOpsManager ops = (AppOpsManager)context.getSystemService("appops");
        try {
            int op = 10021;
            Method method = ops.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
            Integer result = (Integer)method.invoke((Object)ops, op, Process.myUid(), packageName);
            return result == 0;
        }
        catch (Exception e) {
            Log.e((String)"isAllowed", (String)"not support");
            return false;
        }
    }
}

