/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.utils;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import java.util.regex.Pattern;

public class DecimalInputTextWatcher
implements TextWatcher {
    private Pattern mPattern;

    public DecimalInputTextWatcher() {
    }

    public DecimalInputTextWatcher(Type type, int number) {
        if (type == Type.decimal) {
            this.mPattern = Pattern.compile("^[0-9]+(\\.[0-9]{0," + number + "})?$");
        } else if (type == Type.integer) {
            this.mPattern = Pattern.compile("^[0-9]{0," + number + "}+(\\.[0-9]{0,})?$");
        }
    }

    public DecimalInputTextWatcher(int integers, int decimals) {
        this.mPattern = Pattern.compile("^[0-9]{0," + integers + "}+(\\.[0-9]{0," + decimals + "})?$");
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable editable) {
        String text = editable.toString();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (editable.length() > 1 && editable.charAt(0) == '0' && editable.charAt(1) != '.') {
            editable.delete(0, 1);
            return;
        }
        if (text.equals(".")) {
            editable.insert(0, (CharSequence)"0");
            return;
        }
        if (this.mPattern != null && !this.mPattern.matcher(text).matches() && editable.length() > 0) {
            editable.delete(editable.length() - 1, editable.length());
            return;
        }
    }

    public static enum Type {
        integer,
        decimal;

    }
}

