package com.byh.lib.byhim.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.widget.TextView;

import com.kangxin.common.R;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class EmojiUtil {
    private static EmojiUtil INSTANCE = new EmojiUtil();

    private EmojiUtil() {
    }

    public static EmojiUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EmojiUtil();
        }

        return INSTANCE;
    }

    public void showEmoText(Context context, String text, TextView textView) {
        char[] chars = text.toCharArray();
        List<Integer> leftIndexList = new ArrayList<>();
        List<Integer> rightIndexList = new ArrayList<>();
        for (int i = 0; i < chars.length; i++) {
            if (chars[i] == '[') {
                leftIndexList.add(i);
            }

            if (chars[i] == ']') {
                rightIndexList.add(i);
            }
        }

        if (leftIndexList.size() == rightIndexList.size()) {
            SpannableString spannableString = new SpannableString(text);
            for (int index = 0; index < leftIndexList.size(); index++) {

                int startIndex = leftIndexList.get(index);
                int endIndex = rightIndexList.get(index);

                String emojiStr = text.substring(startIndex, endIndex + 1);
                String emoUrl = EmojiMapUtil.INSTANCE.getEmojiUrl(emojiStr);
                if (emoUrl != null) {
                    Bitmap bitmap = BitmapFactory.decodeResource(context.getResources(), R.drawable.ic_placeshow_img);
                    bitmap = UrlImageSpan.zoom(bitmap, DisplayUtil.dp2px(context, UrlImageSpan.EMOJI_SIZE));
                    UrlImageSpan imageSpan = new UrlImageSpan(context, emoUrl, bitmap, textView);
                    spannableString.setSpan(imageSpan, startIndex, endIndex + 1, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                    textView.setText(spannableString);

                } else {
                    textView.setText(text);
                }
            }
        } else {
            textView.setText(text);
        }
    }

    public boolean checkEmojiInText(String text) {
        if (TextUtils.isEmpty(text)) {
            return false;
        }

        Pattern p = Pattern.compile("(\\[[^\\]]*\\])");
        Matcher m = p.matcher(text);
        while (m.find()) {
            return true;
        }
        return false;
    }


}
