package com.byh.lib.byhim.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.DrawableRes;
import androidx.constraintlayout.widget.ConstraintLayout;

import com.kangxin.common.R;
import com.kangxin.common.util.StringUtil;

public class MessageItem extends ConstraintLayout {

    public static final int POINT_VISIBLE = 0;
    public static final int POINT_UNVISIBLE = 8;

    private Context mContext;
    private ImageView mLeftIconImageView;
    private TextView mNameTextView;
    private TextView mContentTextView;
    private TextView mTimeTextView;
    private TextView mPointTextView;

    public MessageItem(Context context) {
        this(context, null);
    }

    public MessageItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MessageItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;

        initViews(attrs);
    }

    private void initViews(AttributeSet attrs) {

        inflate(mContext, R.layout.im_msg_item, this);
        mLeftIconImageView = findViewById(R.id.img_icon);
        mNameTextView = findViewById(R.id.name_txt);
        mContentTextView = findViewById(R.id.content_text);
        mPointTextView = findViewById(R.id.point_txt);
        mTimeTextView = findViewById(R.id.time_txt);

        TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.MessageItem);
        int leftIcon = typedArray.getResourceId(R.styleable.MessageItem_msg_icon, 0);
        String name = typedArray.getString(R.styleable.MessageItem_msg_name);
        String content = typedArray.getString(R.styleable.MessageItem_msg_content);
        String msgTime = typedArray.getString(R.styleable.MessageItem_msg_time);
        int showPoint = typedArray.getIndex(R.styleable.MessageItem_show_point);
        typedArray.recycle();

        mContentTextView.setMaxLines(1);

        setIconRes(leftIcon);
        setName(name);
        setContent(content);
        setTime(msgTime);
        setPointVisible(showPoint);
    }

    public void setPointVisible(int visible) {
        if (visible == POINT_VISIBLE) {
            mPointTextView.setVisibility(View.VISIBLE);
        } else if (visible == POINT_UNVISIBLE) {
            mPointTextView.setVisibility(GONE);
        }
    }


    public void setPointBg(@DrawableRes int res){
        mPointTextView.setBackgroundResource(res);
    }

    public void setPointValue(String value) {
        mPointTextView.setText(value);
    }

    public void setTime(String time) {
        mTimeTextView.setText(time);
    }

    public void setContent(String content) {
        content = StringUtil.changeSubText(content, 15);
        mContentTextView.setText(content);
    }

    public void setIconRes(int id) {
        mLeftIconImageView.setImageResource(id);
    }

    public void setName(String name) {
        mNameTextView.setText(name);
    }

}
