package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Scroller;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;


/**
 * Created by poetr on 17/11/10.
 */

public class PullRecyclerView extends LinearLayout implements NestedScrollingParent {

    private NestedScrollingParentHelper helper = null;
    private MyRecyclerView myRecyclerView = null;
    private int mHeaderHeight = 0;
    private Scroller mScroller;
    private int mCurrent;
    private RefreshListener listener;
    private LoadMoreListener loadMoreListener;
    private boolean isRefreshing;
    private boolean isLoadingMore;
    private boolean nothingMore;

    public PullRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PullRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
        initView();
    }

    private void initView() {
        buildDefaultHeader();
        buildList();
        buildFooter();
    }

    private void buildFooter() {
        Context context = getContext();
        FrameLayout frameLayout = new FrameLayout(context);
        ProgressBar loading = new ProgressBar(context);
        loading.setPadding(0, (int) (mHeaderHeight * 0.2f), 0, (int) (mHeaderHeight * 0.2f));
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, mHeaderHeight);
        frameLayout.addView(loading, params);
        TextView footer = new TextView(getContext());
        footer.setTextColor(0xff666666);
        footer.setTextSize(13f);
        footer.setText(StringsUtils.getString(R.string.onlineoutser_yiwugengduo));
        footer.setGravity(Gravity.CENTER);
        FrameLayout.LayoutParams fp = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, mHeaderHeight);
        frameLayout.addView(footer, fp);
        final LayoutParams pp = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, mHeaderHeight);
        pp.bottomMargin = -mHeaderHeight;
        addView(frameLayout, pp);
        showLoadingMore(true);
    }

    private void showLoadingMore(boolean b) {
        ViewGroup p = (ViewGroup) getChildAt(2);
        if (b) {
            p.getChildAt(0).setVisibility(VISIBLE);
            p.getChildAt(1).setVisibility(GONE);
        } else {
            p.getChildAt(0).setVisibility(GONE);
            p.getChildAt(1).setVisibility(VISIBLE);
        }
    }

    private void buildList() {
        LayoutParams ryp = new LayoutParams(LayoutParams.MATCH_PARENT, 0);
        ryp.weight = 1;
        addView(this.myRecyclerView, ryp);
    }

    private void buildDefaultHeader() {
        ProgressBar defautHeader = new ProgressBar(getContext());
        defautHeader.setPadding(0, (int) (mHeaderHeight * 0.2f), 0, (int) (mHeaderHeight * 0.2f));
        LayoutParams params = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, mHeaderHeight);
        params.topMargin = -mHeaderHeight;
        addView(defautHeader, params);
    }

    private void init() {
        setOrientation(VERTICAL);
        Context context = getContext();
        helper = new NestedScrollingParentHelper(this);
        myRecyclerView = new MyRecyclerView(context);
        mScroller = new Scroller(context, new DecelerateInterpolator(2));
        mHeaderHeight = dpToPx(50f);
    }


    public void nothingMore(boolean b) {
        nothingMore = b;
        showLoadingMore(!b);
    }

    private int dpToPx(float dp) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, getResources().getDisplayMetrics());
    }

    public void setMyRecyclerView(RecyclerView.LayoutManager layoutManager, RecyclerView.Adapter adapter) {
        myRecyclerView.setMyLayoutManager(layoutManager);
        myRecyclerView.setAdapter(adapter);
    }

    public void setMyRecyclerView(RecyclerView.LayoutManager layoutManager, RecyclerView.Adapter adapter, boolean fixed) {
        myRecyclerView.setMyLayoutManager(layoutManager);
        myRecyclerView.setAdapter(adapter);
        myRecyclerView.setHasFixedSize(fixed);
    }

    public MyRecyclerView getMyRecyclerView() {
        return myRecyclerView;
    }

    /**
     * add headerview
     */
    public void addHeaderView(View headerView, int headerHeight) {
        int count = getChildCount();
        if (count > 1) {
            View view = getChildAt(0);
            if (!(view instanceof MyRecyclerView)) {
                try {
                    removeViewAt(0);
                }catch (Exception e){

                }
            }
        }
        mHeaderHeight = headerHeight;
        LayoutParams layoutParams = new LayoutParams(LayoutParams.MATCH_PARENT, headerHeight);
        layoutParams.topMargin = -headerHeight;
        headerView.setLayoutParams(layoutParams);
        addView(headerView, 0, layoutParams);
    }

    public void setLoadMoreListener(LoadMoreListener loadMoreListener) {
        getChildAt(2).setVisibility(VISIBLE);
        this.loadMoreListener = loadMoreListener;
    }

    public void setRefreshListener(RefreshListener listener) {
        this.listener = listener;
    }

    public void refreshComplete() {
        if (mCurrent < 0) {
            smoothScrollTo(-getCurr());
        }
        isRefreshing = false;
    }

    public void loadingMoreComplete() {
        if (mCurrent > 0) {
            smoothScrollTo(-getCurr());
        }
        isLoadingMore = false;
    }

    public boolean isRefreshing() {
        return isRefreshing;
    }

    private int getCurr() {
        return mCurrent;
    }


    @Override
    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return isEnabled() && (nestedScrollAxes & ViewCompat.SCROLL_AXIS_VERTICAL) != 0;
    }

    //parent
    @Override
    public void onNestedScrollAccepted(View child, View target, int axes) {
        helper.onNestedScrollAccepted(child, target, axes);
        mScroller.forceFinished(true);
        if (loadMoreListener != null && myRecyclerView.isFullScreen()) {
            getChildAt(2).setVisibility(VISIBLE);
        } else {
            getChildAt(2).setVisibility(GONE);
        }
    }

    @Override
    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (dy > 0 && mCurrent < 0) {
            mCurrent += dy;
            if (mCurrent > 0) {
                consumed[1] = mCurrent;
                mCurrent = 0;
            } else {
                consumed[1] = dy;
            }
            scrollTo(0, getCurr());
        } else if (dy < 0 && mCurrent > 0) {
            mCurrent += dy;
            if (mCurrent < 0) {
                consumed[1] = mCurrent;
                mCurrent = 0;
            } else {
                consumed[1] = dy;
            }
            scrollTo(0, getCurr());
        }
    }


    @Override
    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed,
                               int dyUnconsumed) {
        mCurrent += dyUnconsumed;
        scrollTo(0, getCurr());
    }


    @Override
    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    @Override
    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    @Override
    public void onStopNestedScroll(View child) {
        helper.onStopNestedScroll(child);
        int d = -getCurr();
        if (listener != null && d >= mHeaderHeight) {
            smoothScrollTo(d - mHeaderHeight);
            if (!isRefreshing) {
                isRefreshing = true;
                listener.onRefresh();
            }
        } else if (d < 0 && loadMoreListener != null &&
                myRecyclerView.isLastPosition() && -d >= mHeaderHeight) {
            smoothScrollTo(d + mHeaderHeight);
            if (!nothingMore && !isLoadingMore) {
                isLoadingMore = true;
                loadMoreListener.onLoadMore();
            }
        } else {
            smoothScrollTo(d);
        }
    }

    @Override
    public int getNestedScrollAxes() {
        return helper.getNestedScrollAxes();
    }

    public void smoothScrollToPosition(int i) {
        myRecyclerView.smoothScrollToPosition(i);
    }

    public void listScrollBy(int y) {
        myRecyclerView.scrollBy(0, y);
    }

    public void scrollToPosition(int i) {
        myRecyclerView.scrollToPosition(i);
    }

    @Override
    public void computeScroll() {
        if (mScroller.computeScrollOffset()) {
            int currY = mScroller.getCurrY();
            mCurrent = currY;
            scrollTo(0, currY);
            invalidate();
        }
    }

    private void smoothScrollTo(int distance) {
        mScroller.startScroll(0, getCurr(), 0, distance, 300);
        invalidate();
    }

    private void startScroll(int distance, int time) {
        mScroller.startScroll(0, getCurr(), 0, distance, time);
        invalidate();
    }

    public interface RefreshListener {
        void onRefresh();
    }

    public interface LoadMoreListener {
        void onLoadMore();
    }

    public static class MyRecyclerView extends RecyclerView {
        private StaggeredGridLayoutManager staggeredGridLayoutManager = null;
        private LinearLayoutManager linearLayoutManager = null;
        private GridLayoutManager gridLayoutManager = null;

        public MyRecyclerView(Context context) {
            super(context);
            setVerticalFadingEdgeEnabled(false);
            setHorizontalFadingEdgeEnabled(false);
            setVerticalScrollBarEnabled(false);
            setHorizontalScrollBarEnabled(false);
            setOverScrollMode(OVER_SCROLL_NEVER);
            setItemAnimator(new DefaultItemAnimator());
        }

        private void setMyLayoutManager(LayoutManager layoutManager) {
            if (layoutManager instanceof StaggeredGridLayoutManager) {
                staggeredGridLayoutManager = (StaggeredGridLayoutManager) layoutManager;
            } else if (layoutManager instanceof GridLayoutManager) {
                gridLayoutManager = (GridLayoutManager) layoutManager;
            } else if (layoutManager instanceof LinearLayoutManager) {
                linearLayoutManager = (LinearLayoutManager) layoutManager;
            }
            setLayoutManager(layoutManager);
            if (!isVertical()) {
                throw new NullPointerException("vertical!");
            }
        }

        public boolean isFirstPosition() {
            LayoutManager layoutManager = getLayoutManager();
            int firstVisibleItemPosition;
            if (layoutManager instanceof GridLayoutManager) {
                firstVisibleItemPosition = ((GridLayoutManager) layoutManager).findFirstVisibleItemPosition();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                int[] into = new int[((StaggeredGridLayoutManager) layoutManager).getSpanCount()];
                ((StaggeredGridLayoutManager) layoutManager).findFirstVisibleItemPositions(into);
                firstVisibleItemPosition = findMix(into);
            } else {
                firstVisibleItemPosition = ((LinearLayoutManager) layoutManager).findFirstVisibleItemPosition();
            }
            return firstVisibleItemPosition <= 0;
        }

        public boolean isLastPosition() {
            LayoutManager layoutManager = getLayoutManager();
            int lastVisibleItemPosition;
            if (layoutManager instanceof GridLayoutManager) {
                lastVisibleItemPosition = ((GridLayoutManager) layoutManager).findLastVisibleItemPosition();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                int[] into = new int[((StaggeredGridLayoutManager) layoutManager).getSpanCount()];
                ((StaggeredGridLayoutManager) layoutManager).findLastVisibleItemPositions(into);
                lastVisibleItemPosition = findMax(into);
            } else {
                lastVisibleItemPosition = ((LinearLayoutManager) layoutManager).findLastVisibleItemPosition();
            }
            return lastVisibleItemPosition == layoutManager.getItemCount() - 1;
        }

        private int findMix(int[] firstPositions) {
            int min = firstPositions[0];
            for (int value : firstPositions) {
                if (value < min) {
                    min = value;
                }
            }
            return min;
        }

        private int findMax(int[] lastPositions) {
            int max = lastPositions[0];
            for (int value : lastPositions) {
                if (value > max) {
                    max = value;
                }
            }
            return max;
        }

        /**
         * orientation
         * 0 menas down
         * 1 means up
         */
        public boolean isOrientation(int orientation) {
            if (orientation == 0) {
                return isCanPullDown();
            } else if (orientation == 1) {
                return isCanPullUp();
            }
            return false;
        }

        private boolean isCanPullDown() {
            return !canScrollVertically(-1);
        }

        private boolean isCanPullUp() {
            return !canScrollVertically(1);
        }

        private boolean isVertical() {
            if (staggeredGridLayoutManager != null) {
                return staggeredGridLayoutManager.getOrientation() == StaggeredGridLayoutManager.VERTICAL;
            } else if (linearLayoutManager != null) {
                return linearLayoutManager.getOrientation() == RecyclerView.VERTICAL;
            } else if (gridLayoutManager != null) {
                return gridLayoutManager.getOrientation() == RecyclerView.VERTICAL;
            }
            return false;
        }

        private boolean isFullScreen() {
            final int height = getMeasuredHeight();
            if (linearLayoutManager != null) {
                final int lastP = linearLayoutManager.findLastVisibleItemPosition();
                if (lastP == -1) return false;
                final View last = linearLayoutManager.findViewByPosition(lastP);
                return last.getBottom() >= height;
            }
            return false;
        }
    }
}
