package com.byh.module.onlineoutser.view;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;

import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

import org.jetbrains.annotations.NotNull;


public class RemoImFooter extends LinearLayout {

    private EventListener onMsgSendListener;
    private EditText mInputMsgEdtView;
    private ImageView mSendMsgBtnView;

    public RemoImFooter(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RemoImFooter(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();

    }

    private void init() {
        setOrientation(VERTICAL);
        View rootView = LayoutInflater.from(getContext()).inflate(R.layout.remo_teach_im_footer, this, false);
        addView(rootView);
        mInputMsgEdtView = findViewById(R.id.mInputMsgEdtView);
        mSendMsgBtnView = findViewById(R.id.mSendMsgButton);
        initInputMsgView();
        initSendMsgBtn();
    }

    private void initSendMsgBtn() {
        mSendMsgBtnView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                String inputMsg = mInputMsgEdtView.getText().toString();
                if (TextUtils.isEmpty(inputMsg)) {
                    ToastUtils.showShort(StringsUtils.getString(R.string.onlineoutser_xiaoxibunengweikong));
                    return;
                }

                mInputMsgEdtView.setText("");

                if (onMsgSendListener != null) {
                    onMsgSendListener.onText(inputMsg);
                }
            }
        });
    }

    public void setOnMsgSendListener(EventListener eventListener) {
        this.onMsgSendListener = eventListener;
    }

    public void setEdtFocusable(boolean flag) {
        mInputMsgEdtView.setFocusable(flag);
    }

    private void initInputMsgView() {

        mInputMsgEdtView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                if (s.toString().length() > 0) {
                    mSendMsgBtnView.setVisibility(VISIBLE);
                } else {
                    mSendMsgBtnView.setVisibility(GONE);
                }
            }
        });

    }

    public interface EventListener {
        void onText(@NotNull String text);
    }
}
