package com.kangxin.common.base;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

@Deprecated
public abstract class BaseFragment extends Fragment {
    public Context mContext;
    public BaseActivity mActivity;
    public LayoutInflater mInflater;

    protected View mView;

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        if (mView == null) {
            mContext = getContext();
            mActivity = (BaseActivity) getActivity(); // 进行赋值，这样就可以避免快速滑动时 导致的崩溃
            mInflater = LayoutInflater.from(mContext);
            mView = createView(); // 抽象方法，留给子类去实现自己的布局
        }

        return mView;
    }

    /**
     * 解决快速滑动Fragment时崩溃的问题
     */
    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (mView != null && mView.getParent() != null) {
            ViewGroup viewGroup = (ViewGroup) mView.getParent();
            try {
                viewGroup.removeView(mView);
            }catch (Exception e){

            }
        }
    }

    public void showShortToast(String msg) {
        Toast.makeText(getActivity().getApplicationContext(), msg, Toast.LENGTH_SHORT).show();
    }

    public void showLongToast(String msg) {
        Toast.makeText(getActivity().getApplicationContext(), msg, Toast.LENGTH_LONG).show();
    }

    public abstract void initData(Bundle bundle);

    public abstract void initView();

    public abstract View createView();
}
