package com.kangxin.common.base;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;

import com.blankj.utilcode.util.Utils;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.Pretty;
import com.kangxin.common.R;
import com.kangxin.common.base.rmvp.BaseActivity;

import java.util.ArrayList;

public class DynamicImageActivity extends BaseActivity {

  private static final String IMAGE = "images";

  public static void start(ArrayList<String> images) {
    Bundle bundle = new Bundle();
    bundle.putStringArrayList(IMAGE, images);
    Intent intent = new Intent(Utils.getApp(), DynamicImageActivity.class);
    intent.putExtras(bundle);
    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
    Utils.getApp().startActivity(intent);
  }

  @SuppressLint("StringFormatMatches")
  @Override
  public void goStart() {
    ViewPager2 viewPager = findViewById(R.id.viewPager);
    if (getIntent().getExtras() == null) {
      finish();
      return;
    }
    ArrayList<String> arrayList = getIntent().getExtras().getStringArrayList(IMAGE);
    if (arrayList == null) {
      finish();
      return;
    }
    vToolTitleTextView.setText(String.format(getString(R.string.inc_dynamic_image_title), 1, arrayList.size()));
    viewPager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback() {
      @Override
      public void onPageSelected(int position) {
        vToolTitleTextView.setText(String.format(getString(R.string.inc_dynamic_image_title), position + 1, arrayList.size()));
      }
    });
    viewPager.setAdapter(new RecyclerView.Adapter<BaseViewHolder>() {
      @NonNull
      @Override
      public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new BaseViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.inc_dynamic_image_item, parent, false));
      }

      @Override
      public void onBindViewHolder(@NonNull BaseViewHolder holder, int position) {
        Pretty.create()
          .loadImage(arrayList.get(position))
          .into(holder.getView(R.id.image));
      }

      @Override
      public int getItemCount() {
        return arrayList.size();
      }
    });
  }

  @Override
  public int getContentLayoutId() {
    return R.layout.inc_activity_dynamic_image;
  }
}
