package com.kangxin.common.base.mvvm.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;


import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.Fragment;

import com.alibaba.android.arouter.launcher.ARouter;
import com.kangxin.common.BR;
import com.kangxin.common.base.mvvm.http.RxRetrofitClient;
import com.kangxin.common.base.mvvm.model.EventEntity;
import com.kangxin.common.base.mvvm.vm.BaseVMModel;
import com.tbruyelle.rxpermissions.RxPermissions;

import me.yokeyword.fragmentation.SupportFragment;

/**
 * @param <VM> fragment 的所有父类  fragment都应该集成此BaseFragment
 */
public abstract class BaseFragment<VM extends BaseVMModel> extends SupportFragment {


    protected VM vm;
    protected View rootView;

    protected Activity mContext;

    /**
     * 权限请求控制，无需向子类暴露
     * 直接请求父类对应方法即可
     */
    private  RxPermissions mRxPermissions;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }


    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        init(inflater, container);
        // 解决fragment UI重复加载
        ViewGroup parent = (ViewGroup) rootView.getParent();
        if (parent != null) {
            parent.removeView(rootView);
        }

        return rootView;
    }


    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initView();
    }

    protected void hideSoftKeyboard() {
        View view = getActivity().getWindow().peekDecorView();
        if (view != null) {
            InputMethodManager inputmanger = (InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
            inputmanger.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventMainThread(EventEntity event) {
        // TODO Auto-generated method stub

    }

    @Subscribe(threadMode = ThreadMode.ASYNC)
    public void onEventAsync(EventEntity event) {
        // TODO Auto-generated method stub
    }

    @Subscribe(threadMode = ThreadMode.BACKGROUND)
    public void onEventBackgroundThread(EventEntity event) {
        // TODO Auto-generated method stub
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    /***
     * 初始化view(加载布局)
     */
    protected abstract int getLayoutID();

    /**
     * 初始化VModel
     *
     * @return
     */
    protected abstract Class<VM> getVModelClass();

    /**
     * 处理界面相关
     */
    public abstract void initView();

    @Override
    public void onPause() {
        super.onPause();
        hideSoftKeyboard();
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (hidden) {
            hideSoftKeyboard();
        }
    }

    private void init(LayoutInflater inflater, ViewGroup container) {
        try {
            rootView = inflater.inflate(getLayoutID(), container, false);
            vm = getVModelClass().newInstance();
            vm.bind = DataBindingUtil.bind(rootView);
            vm.bind.setVariable(BR.vm, vm);
            vm.mContext = getActivity();
            mContext = getActivity();
            vm.rxClient = RxRetrofitClient.getClient();
            vm.initPresenter();
            getLifecycle().addObserver(vm);
        } catch (java.lang.InstantiationException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        //创建rx动态权限对象
        mRxPermissions = RxPermissions.getInstance(mContext);
        //设置rx权限log
        mRxPermissions.setLogging(true);
        //注入对象
        ARouter.getInstance().inject(this);
    }
}
