package com.kangxin.common.base.mvvm.http;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.mvvm.i.ICallBack;
import com.kangxin.common.base.mvvm.resp.ResponseBean;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.ConnectException;
import java.security.spec.ECField;

import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import okhttp3.HttpUrl;
import okhttp3.ResponseBody;
import retrofit2.HttpException;
import retrofit2.Response;


/**
 * Created by Administrator on 2017/3/16.
 */

public class BaseObserver implements Observer<ResponseBean> {

    private String identifyString = "访问此资源需要完全的身份验证";
    private ICallBack iCallBack;
    private Class clazz;
    private CompositeDisposable compositeDisposable;
    private long startTime;
    private Disposable mDisposable;

    public BaseObserver(ICallBack callBack, Class clazz, CompositeDisposable compositeDisposable) {
        this.iCallBack = iCallBack;
        this.clazz = clazz;
        this.compositeDisposable = compositeDisposable;
    }

    @Override
    public void onComplete() {
        if (compositeDisposable != null) {
            if (mDisposable != null) {
                compositeDisposable.delete(this.mDisposable);
            }
        }
        if (iCallBack != null) {
            iCallBack.onFinish();
        }
    }

    @Override
    public void onError(Throwable e) {
        e.printStackTrace();
        long endTime = System.currentTimeMillis();
        //数据请求成功，只是个成功标示
        if (e.toString().contains("com.google.gson.JsonSyntaxException")) {
            return;
        }

        onComplete();
    }


    @Override
    public void onSubscribe(Disposable d) {
        if (compositeDisposable != null) {
            this.mDisposable = d;
            compositeDisposable.add(d);
        }
        if (iCallBack != null) {
            iCallBack.onStart();
        }
    }

    @Override
    public void onNext(ResponseBean responseBean) {
        ResponseBean respBean = HttpDataTools.getResponseData(responseBean, clazz);
        switch (respBean.getCode()) {
            case 0:
                if (iCallBack != null) {
                    iCallBack.onSuccess(respBean);
                }
                break;
            default:
                if (iCallBack != null) {
                    iCallBack.onError(respBean,respBean.getMsg(),respBean.getErrCode());
                }
                break;
        }
        if (compositeDisposable != null) {
            if (mDisposable != null) {
                compositeDisposable.delete(this.mDisposable);
            }
        }
    }
}
