package com.kangxin.common.base.mvvm.http;


import android.text.TextUtils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kangxin.common.base.mvvm.i.UploadProgressListener;
import com.kangxin.common.base.mvvm.requestbean.FileBean;
import com.kangxin.common.base.mvvm.requestbean.RequestBean;
import com.kangxin.common.base.mvvm.requestbean.baseBean.BaseRequestBean;
import com.kangxin.common.base.mvvm.requestbean.baseBean.BaseUploadBean;
import com.kangxin.common.base.mvvm.requestbean.baseBean.BaseUploadItem;
import com.kangxin.common.base.mvvm.requestbean.baseBean.ProgressRequestBody;
import com.kangxin.common.base.mvvm.requestbean.httpcode.HttpsCode;
import com.kangxin.common.base.mvvm.resp.ResponseBean;
import com.kangxin.common.guide.util.LogUtil;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class HttpDataTools {

    public static final String unNeedStr = "-2000";
    public static final int unNeed = -2000;

    public static final String TAG = HttpDataTools.class.getSimpleName();


    /**
     * 处理URL改装
     *
     * @return
     */
    public static String getPath(String path) {
        // 域名后缀的方法名
//        String allowedChars = "._-$,;~()/";
//        String pathEncoded = Uri.encode(path, allowedChars);
//        RxOkHttpLog.d("请求URL---->" + (0 == baseUrlType ? HttpConstants.BASE_DEV_VIDEO_URL : HttpConstants.BASE_DEV_URL) + path);
        return path;
    }


    /**
     * 处理请求bean
     *
     * @param bean
     * @return
     */
    public static RequestBody getPostSendData(RequestBean bean) {

        if (bean == null) {
            return RequestBody.create(HttpsCode.INSTANCE.getMediaTypeJson(), "");
        }
        String sentData = "";

        BaseRequestBean bsrqBean = bean.getBsrqBean();
        Gson gson = new Gson();
        sentData = gson.toJson(bean.getBsrqBean());
        // 创建一个RequestBody(参数1：数据类型 参数2传递的json串)
        RequestBody requestBody = RequestBody.create(HttpsCode.INSTANCE.getMediaTypeJson(), sentData);
        LogUtil.d("请求参数---->" + sentData);

        return requestBody;
    }

    /**
     * 处理请求bean
     *
     * @param bean
     * @return
     */
    public static Map<String, RequestBody> getUploadSendData(RequestBean bean, UploadProgressListener listener) {

        Map<String, RequestBody> reqMap = new HashMap<String, RequestBody>();
        LogUtil.d("参数---->");
        if (bean.getBsrqBean() == null) {
            return reqMap;
        }
        for (BaseUploadItem item : ((BaseUploadBean) bean.getBsrqBean()).getPathList()) {
            File file = new File(item.getPath());
            if (file.exists()) {

                RequestBody requestBody = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                ProgressRequestBody progressRequestBody = new ProgressRequestBody(requestBody, listener);
                reqMap.put("images\";images=\"" + file.getName() + "\"", progressRequestBody);
            }

        }
        return reqMap;
    }


    /**
     * 处理请求bean
     * 多文件上传
     *
     * @param bean
     * @return
     */
    public static List<MultipartBody.Part> getUploadPartFiles(RequestBean bean, UploadProgressListener listener) {

        List<MultipartBody.Part> list = new ArrayList<>();
        LogUtil.d("参数---->");
        if (bean.getBsrqBean() == null) {
            return list;
        }
        for (String item : ((FileBean) bean.getBsrqBean()).getFiles()) {
            File file = new File(item);
            if (file.exists()) {

                RequestBody requestBody = RequestBody.create(MediaType.parse(bean.getMediaType()), file);
                ProgressRequestBody progressRequestBody = new ProgressRequestBody(requestBody, listener);
                MultipartBody.Part part = null;
                try {
                    part = MultipartBody.Part.createFormData(bean.getFileName(), URLEncoder.encode(file.getName(), "UTF-8"), progressRequestBody);
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                list.add(part);
            }

        }
        return list;
    }

    /**
     * 处理请求bean
     * 多文件上传
     *
     * @param bean
     * @return
     */
    public static List<MultipartBody.Part> getUploadPartFilesWithFile(RequestBean bean, UploadProgressListener listener) {

        List<MultipartBody.Part> list = new ArrayList<>();
        LogUtil.d("参数---->");
        if (bean.getBsrqBean() == null) {
            return list;
        }
        for (File file : ((FileBean) bean.getBsrqBean()).getFileList()) {
            if (file.exists()) {

                RequestBody requestBody = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                ProgressRequestBody progressRequestBody = new ProgressRequestBody(requestBody, listener);
                MultipartBody.Part part = null;
                try {
                    part = MultipartBody.Part.createFormData("files", URLEncoder.encode(file.getName(), "UTF-8"), progressRequestBody);
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                list.add(part);
            }

        }
        return list;
    }

    /**
     * 处理请求bean
     * 单文件上传
     *
     * @param bean
     * @param listener
     * @return
     */
    public static MultipartBody.Part getUploadPartFile(BaseRequestBean bean, UploadProgressListener listener) {

        MultipartBody.Part part = null;
        LogUtil.d("参数---->");
        if (bean == null) {
            return part;
        }
        String filePath = ((FileBean) bean).getFilePath();
        File file = new File(filePath);
        if (file.exists()) {

            LogUtil.d("path  single-->" + filePath);
            RequestBody requestBody = RequestBody.create(MediaType.parse("multipart/form-data"), file);
            ProgressRequestBody progressRequestBody = new ProgressRequestBody(requestBody, listener);
            try {
                part = MultipartBody.Part.createFormData("files", URLEncoder.encode(file.getName(), "UTF-8"), progressRequestBody);
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        return part;
    }


    /**
     * 处理多文件
     */

    private RequestBody buildMultipartRequestBody(List<File> files, String filesKey, HashMap<String, String> params) {
        if (params == null) {
            params = new HashMap<>();
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        Set<String> strings = params.keySet();
        for (String key : strings) {
            builder.addPart(Headers.of("Content-Disposition", "form-data; name=\"" + key + "\""),
                    RequestBody.create(null, params.get(key)));
        }
        if (files == null) {
            files = new ArrayList<>();
        }
        int size = files.size();
        if (size == 0) {
            builder.addPart(Headers.of("Content-Disposition", "form-data; name=\"" + filesKey + "\""),
                    RequestBody.create(null, "[]"));
        }
        for (int i = 0; i < size; i++) {
            //TODO 根据文件名设置contentType
            builder.addPart(Headers.of("Content-Disposition",
                    "form-data; name=\"" + filesKey + "\"; fileName=\"" + System.currentTimeMillis() + "\""),
                    RequestBody.create(MediaType.parse("multipart/form-data"), files.get(i)));
        }
        return builder.build();

    }


    /**
     * 处理请求bean
     *
     * @return
     */
    public static Map<String, String> getGetSendData(Object obj) {

        Map<String, String> map = new LinkedHashMap<>();
        if (obj == null) {
            return map;
        }
        //key值 应该是 Person类中的属性名，利用反射机制
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {
            String field = fields[i].toString();
            String[] keys = field.split("\\.");
            String key = keys[keys.length - 1];
            char[] cs = key.toCharArray();
            cs[0] -= 32;
            String keyUpper = String.valueOf(cs);
//            char toUpperCase = (char) (key.charAt(0) - 32);
//            String keyUpper = key.replace(key.charAt(0), toUpperCase);
            Method getMethod;
            try {
                if (!keyUpper.toLowerCase().equals("SerialVerSionUID".toLowerCase())) {

                    getMethod = obj.getClass().getDeclaredMethod("get" + keyUpper);//根据 field得到对应的get方法
                    String value = getMethod.invoke(obj) + "";
                    if (!TextUtils.isEmpty(value) && !value.equals("null") && !value.equals(unNeedStr)) {
                        map.put(key, value);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        LogUtil.d("请求参数-------->" + map);
        return map;
    }


    /***
     * 获取泛型的类型
     *
     * @param raw:要获取Type类型的目标类
     * @param args
     * @return
     */
    public static ParameterizedType type(final Class<?> raw, final java.lang.reflect.Type... args) {
        return new ParameterizedType() {
            public java.lang.reflect.Type getRawType() {
                return raw;
            }

            public java.lang.reflect.Type[] getActualTypeArguments() {
                return args;
            }

            public java.lang.reflect.Type getOwnerType() {
                return null;
            }
        };
    }

    /**
     * 处理返回数据for okhttp
     *
     * @param responseBean
     * @param clazz
     * @return
     */
    @SuppressWarnings({"rawtypes", "unchecked"})
    public static ResponseBean getResponseData(ResponseBean responseBean, Class<?> clazz) {
        LogUtil.d("请求返回---------->" + responseBean.toString());
        if (TextUtils.isEmpty(responseBean.getData() + "")) {
            return responseBean;
        }
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            String jsonStr = gson.toJson(responseBean.getData());
            if (clazz == null) {
                responseBean.setData(jsonStr);
            } else {
                responseBean.setData(gson.fromJson(jsonStr, clazz));
            }

        } catch (Exception e) {
        }

        return responseBean;
    }


}
