package com.kangxin.common.base.mvvm.http;



import com.kangxin.common.base.mvvm.api.ApiServer;
import com.kangxin.common.base.mvvm.i.ICallBack;
import com.kangxin.common.base.mvvm.i.UploadProgressListener;
import com.kangxin.common.base.mvvm.requestbean.RequestBean;
import com.kangxin.common.base.mvvm.requestbean.httpcode.HttpsCode;
import com.kangxin.common.guide.util.LogUtil;
import com.kangxin.common.http.interceptor.Interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;


/**
 *
 */
public class RxRetrofitClient {

    private static RxRetrofitClient mClient;
    private OkHttpClient mOkHttpClient;
    private ApiServer apiServer;
    private Retrofit retrofit;
    //拦截器列表
    private ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();

    private final long READ_TIMEOUT = 20;
    private final long WRITE_TIMEOUT = 30;
    private final long CONNECT_TIMEOUT = 10;

    private RxRetrofitClient(){

    }

    private RxRetrofitClient(String url) {
        if (mOkHttpClient == null) {
            mOkHttpClient = new OkHttpClient.Builder()
                    .readTimeout(READ_TIMEOUT, TimeUnit.SECONDS)//设置读取超时时间
                    .writeTimeout(WRITE_TIMEOUT, TimeUnit.SECONDS)//设置写的超时时间
                    .connectTimeout(CONNECT_TIMEOUT, TimeUnit.SECONDS)//设置连接超时时间
                    .build();
        }
        retrofit = new Retrofit.Builder()
                .addConverterFactory(GsonConverterFactory.create())
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .baseUrl(url)
                .client(mOkHttpClient)
                .build();

        apiServer = retrofit.create(ApiServer.class);
    }


    public static RxRetrofitClient getClient(String url) {
        if (mClient == null) {
            synchronized (RxRetrofitClient.class) {
                mClient = new RxRetrofitClient(url);
            }
        }
        return mClient;
    }


    public static RxRetrofitClient getClient() {
        if (mClient == null) {
            throw (new NullPointerException("请在使用前调用getClient（url) 进行初始化"));
        }
        return mClient;
    }


    public void addInterceptor(okhttp3.Interceptor interceptor, int level){

        //ok拦截器以及拦截等级封装
        Interceptor levelInterceptor = new Interceptor(interceptor, level);
        //存入容器
        interceptors.add(levelInterceptor);
        //容器排序
        Collections.sort(interceptors);

        mOkHttpClient.interceptors().clear();

        OkHttpClient.Builder builder = mOkHttpClient.newBuilder();

        for (Interceptor interceptor1 : interceptors) {

            builder.addInterceptor(interceptor1.getInterceptor());
        }
        mOkHttpClient= builder.build();
        Retrofit.Builder builder1 = retrofit.newBuilder();
        retrofit = builder1.client(mOkHttpClient).build();
        apiServer = retrofit.create(ApiServer.class);

    }

    //请求后台数据
    public void execute(final RequestBean requestBean, ICallBack callBack) {
        LogUtil.d("请求方式---->" + requestBean.getRequestMethod());
        switch (requestBean.getRequestMethod()) {
            case HttpsCode.METHOD_GET:
                apiServer.get(HttpDataTools.getPath(requestBean.getPath()), HttpDataTools.getGetSendData(requestBean.getBsrqBean()))
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
            case HttpsCode.METHOD_GET_JOINT:
                apiServer.get(HttpDataTools.getPath(requestBean.getPath()))
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
            case HttpsCode.METHOD_POST:
                apiServer.post(HttpDataTools.getPath(requestBean.getPath()), HttpDataTools.getPostSendData(requestBean))
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
            case HttpsCode.METHOD_POST_QUERY:
                apiServer.postQuery(HttpDataTools.getPath(requestBean.getPath()), HttpDataTools.getGetSendData(requestBean.getBsrqBean()))
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
            case HttpsCode.METHOD_POST_FILE:
                apiServer.upLoadFile(HttpDataTools.getPath(requestBean.getPath()), HttpDataTools.getUploadPartFile(requestBean.getBsrqBean(), new UploadProgressListener() {
                    @Override
                    public void onProgress(long currentBytesCount, long totalBytesCount) {
                    }
                }))
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
            case HttpsCode.METHOD_POST_FILES:
                apiServer.upLoadFiles(HttpDataTools.getPath(requestBean.getPath()), HttpDataTools.getUploadPartFiles(requestBean, new UploadProgressListener() {
                    @Override
                    public void onProgress(long currentBytesCount, long totalBytesCount) {
                    }
                }))
                        //form表单提交
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
            case HttpsCode.METHOD_PUT:
                apiServer.put(HttpDataTools.getPath(requestBean.getPath()), HttpDataTools.getPostSendData(requestBean))
                        //form表单提交
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
            case HttpsCode.METHOD_PUT_QUERY:
                apiServer.put(HttpDataTools.getPath(requestBean.getPath()), HttpDataTools.getGetSendData(requestBean.getBsrqBean()))
                        //form表单提交
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
            case HttpsCode.METHOD_DELETE:
                apiServer.delete(HttpDataTools.getPath(requestBean.getPath()))
                        //form表单提交
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
            case HttpsCode.METHOD_DELETE_QUERY:
                apiServer.delete(HttpDataTools.getPath(requestBean.getPath()), HttpDataTools.getGetSendData(requestBean.getBsrqBean()))
                        //form表单提交
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new BaseObserver(callBack,null,null));
                break;
        }
    }

}