package com.kangxin.common.base.mvvm.i;


import android.app.AlertDialog;
import android.content.Context;
import android.view.View;
import android.view.Window;
import android.widget.LinearLayout;

import com.kangxin.common.R;
import com.kangxin.common.base.mvvm.resp.ResponseBean;
import com.kangxin.common.util.GlobeLoadingHelper;

import java.lang.ref.WeakReference;


public abstract class ICallBack {


    // 请求数据进度条
    public AlertDialog dialogprogress = null;

    private WeakReference<Context> weakContext;

    private boolean isShowProgress;

    /**
     *
     * @param context 上下文
     * @param isShowProgress 是否显示加载条
     */
    public ICallBack(Context context, boolean isShowProgress) {

        weakContext = new WeakReference<>(context);
        this.isShowProgress = isShowProgress;
    }


    public void onFinish() {
        // TODO Auto-generated method stub
        closeProgress();
    }

    public void onStart() {
        // TODO Auto-generated method stub
        // 显示进度条
        if (isShowProgress) {
            showProgress(weakContext.get());
        }
    }

    public abstract void onSuccess(ResponseBean responseBean);

    public abstract void onError(ResponseBean responseBean,String code, String msg);

    /**
     * 是否显示成功的提示
     * @return
     */
    public abstract boolean successToast();

    /**
     * 是否显示错误的提示
     * @return
     */
    public abstract boolean errorToast();

    public void showProgress(Context context) {
        if (context != null) {
            GlobeLoadingHelper.show(context);
        }
    }

    /***
     * 关闭进度框
     */
    public void closeProgress() {
        GlobeLoadingHelper.dissmiss();
    }
}
