package com.kangxin.common.base.mvvm.options;

import android.content.Context;

import androidx.annotation.DrawableRes;
import androidx.databinding.BaseObservable;
import androidx.databinding.Bindable;
import androidx.lifecycle.ViewModel;

import com.kangxin.common.BR;
import com.kangxin.common.R;
import com.kangxin.common.base.mvvm.model.BaseModel;

import java.io.Serializable;

/**
 * @author dongweizhou
 * @time 3/31/22
 * @describe  头部的UI 样式管理类
 **/
public class TitleOptions extends BaseModel implements Serializable {

    public static final int NULL_RES = -1;


    private String centerTitle="我的工作台";

    @DrawableRes
    private int leftImage;

    private String leftTitle;

    private String rightTitle;

    @DrawableRes
    private int rightImage;

    /**
     * 改变左边的点击事件
     */
    private boolean changeLeftClick;

    public boolean isChangeLeftClick() {
        return changeLeftClick;
    }

    public void setChangeLeftClick(boolean changeLeftClick) {
        this.changeLeftClick = changeLeftClick;
    }

    public String getCenterTitle() {
        return centerTitle;
    }

    public void setCenterTitle(String centerTitle) {
        this.centerTitle = centerTitle;
    }

    public int getLeftImage() {
        return leftImage;
    }

    public void setLeftImage(int leftImage) {
        this.leftImage = leftImage;
    }

    public String getLeftTitle() {
        return leftTitle;
    }

    public void setLeftTitle(String leftTitle) {
        this.leftTitle = leftTitle;
    }


    public String getRightTitle() {
        return rightTitle;
    }

    public void setRightTitle(String rightTitle) {
        this.rightTitle = rightTitle;
    }


    public int getRightImage() {
        return rightImage;
    }

    public void setRightImage(int rightImage) {
        this.rightImage = rightImage;
    }





    public static TitleOptions getDef(String title, Context context){
        TitleOptions titleOptions = new TitleOptions();
        titleOptions.setCenterTitle(title);
        titleOptions.setLeftImage(R.drawable.ic_fanhui);
        titleOptions.setRightTitle("");
        titleOptions.setRightImage(NULL_RES);
        return titleOptions;
    }


}
