package com.kangxin.common.byh.activity;


import android.view.View;
import android.widget.TextView;

import androidx.viewpager.widget.ViewPager;

import com.kangxin.common.R;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.imageshow.PhotoViewAdapter;

import java.util.List;

/**
 * 浏览大图
 */
public class MulitImageShowActivity extends BaseActivity {

    private static final String TAG = "MulitImageShowActivity";

    private List<String> images;
    private int position;

    private void init() {

        ViewPager viewPager = findViewById(R.id.view_pager);
        viewPager.setAdapter(new PhotoViewAdapter(images));
        viewPager.setCurrentItem(position);
        TextView imgNumView = findViewById(R.id.img_num);
        int imgNum  = 0;
        if(images != null){
            imgNum = images.size();
        }
        imgNumView.setText(position + 1 + "/" + imgNum);
        int finalImgNum = imgNum;
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                imgNumView.setText(position + 1 + "/" + finalImgNum);
            }

            @Override
            public void onPageSelected(int position) {

            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });


        findViewById(R.id.mBackBtn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }



    @Override
    public void start() {
        //展示的图片数组
        images = getIntent().getStringArrayListExtra("images");

        //位置
        position = getIntent().getIntExtra("position", 0);

        init();
    }

    @Override
    public int getContentLayoutId() {
        return R.layout.mulit_image_show;
    }

    @Override
    public boolean initYm() {
        return true;
    }
}
