package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.R;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.scwang.smartrefresh.layout.listener.OnLoadmoreListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;

import java.util.Collection;
import java.util.List;

/**
 * 具有拉下刷新，上拉加载，空占位功能的列表显示的view
 */
public class SmartRecyclerView extends RelativeLayout {

    private SmartRefreshLayout mSmartRefreshLayoutView;
    private RecyclerView mRecyclerView;
    private BaseQuickAdapter mAdapter;
    private int mIndex = 1;

    private int mImgId;
    private String mBtnText;
    private String mDefDescText;
    private String mDefDescEnglishText;


    public interface OnClickDefEmptyBtnListener{
        void onClickDefBtnView(View view);
    }

    private OnClickDefEmptyBtnListener onClickDefEmptyBtnListener;

    public void setOnClickDefEmptyBtnListener(OnClickDefEmptyBtnListener onClickDefEmptyBtnListener) {
        this.onClickDefEmptyBtnListener = onClickDefEmptyBtnListener;
    }

    public SmartRecyclerView(Context context) {
        this(context, null);
    }

    public SmartRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }


    public SmartRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        View smartRootView = LayoutInflater.from(context).inflate(R.layout.commbyh_smart_recyclerview_list_layout, this, false);
        addView(smartRootView);

        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SmartRecyclerView);

        if (typedArray != null) {
            mImgId = typedArray.getResourceId(R.styleable.SmartRecyclerView_seat_img, 0);
            mDefDescText = typedArray.getString(R.styleable.SmartRecyclerView_seat_desc);
            mBtnText = typedArray.getString(R.styleable.SmartRecyclerView_seat_btn_text);
            mDefDescEnglishText = typedArray.getString(R.styleable.SmartRecyclerView_seat_desc_eng);
            typedArray.recycle();
        }


        mSmartRefreshLayoutView = findViewById(R.id.smart_refresh_layout);
        mSmartRefreshLayoutView.setRefreshHeader(new ClassicsHeader(context));
        mSmartRefreshLayoutView.setRefreshFooter(new ClassicsFooter(context));
        mRecyclerView = findViewById(R.id.recycler_list);
        mRecyclerView.setLayoutManager(new LinearLayoutManager(context));
    }

    public SmartRecyclerView setAdapter(BaseQuickAdapter baseQuickAdapter) {
        mAdapter = baseQuickAdapter;
        mRecyclerView.setAdapter(baseQuickAdapter);
        return this;
    }

    public boolean isRefresh() {
        return mSmartRefreshLayoutView.isRefreshing() || mSmartRefreshLayoutView.isLoading();
    }

    public SmartRecyclerView autoRefresh() {
        mSmartRefreshLayoutView.autoRefresh();
        return this;
    }

    public SmartRecyclerView addItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        mRecyclerView.addItemDecoration(decor);
        return this;
    }

    public SmartRecyclerView setRecyclerViewColor(@ColorInt int color) {
        mRecyclerView.setBackgroundColor(color);
        return this;
    }

    public int getIndex() {
        return mIndex;
    }

    public void setIndex(int index) {
        mIndex = index;
    }

    public void showNoData() {
        if (mIndex == 1) {
            if(mDefEmptyPage != null){
                mDefEmptyPage.showDef(true);
            }else {
                initDefEmptyPage(null);
            }
        }
    }


    private DefaultEmptyPage mDefEmptyPage;


    private <T> void initDefEmptyPage(Collection<? extends T> newData){
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(getContext())
                .setDefImgid(mImgId)
                .setDefDescText(mDefDescText)
                .setDefEngText(mDefDescEnglishText)
                .setDefBtnText(mBtnText)
                .setDataList((List) newData)
                .setBusViewGroup(mRecyclerView)
                .setOnDefpageClickListener(new DefaultEmptyPage.OnDefpageClickListener() {
                    @Override
                    public void onClickDefbtn(View view) {
                        if(onClickDefEmptyBtnListener != null){
                            onClickDefEmptyBtnListener.onClickDefBtnView(view);
                        }
                    }
                }).create();
    }


    /**
     * 加载数据
     *
     * @param newData
     * @param <T>
     */
    public <T> void loadDatas(Collection<? extends T> newData) {

        mSmartRefreshLayoutView.finishRefresh();
        mSmartRefreshLayoutView.finishLoadmore();

        initDefEmptyPage(newData);

        mDefEmptyPage.showDef(false);
        if (newData == null || newData.isEmpty() || mAdapter == null) {
            if (mIndex == 1) {
                mDefEmptyPage.showDef(true);
            }
            return;
        }

        if (mIndex == 1) {
            mAdapter.getData().clear();
            mAdapter.addData(newData);
        } else {
            mAdapter.addData(mAdapter.getItemCount(), newData);
        }
    }

    /**
     * 设置是否打开下拉刷新与上拉加载
     *
     * @param isRefresh
     * @param isLoadMore
     */
    public void setEnablePullAndLoadMore(boolean isRefresh, boolean isLoadMore) {
        mSmartRefreshLayoutView.setEnableRefresh(isRefresh);
        mSmartRefreshLayoutView.setEnableLoadmore(isLoadMore);
    }

    public void finishRefAndLoadMore() {
        mSmartRefreshLayoutView.finishLoadmore();
        mSmartRefreshLayoutView.finishRefresh();
    }

    /**
     * 设置下拉刷新与上拉加载的监听
     *
     * @param onPullRefreshListener
     */
    public void setOnPullRefreshListener(OnPullRefreshListener onPullRefreshListener) {
        mSmartRefreshLayoutView.setOnRefreshListener(new OnRefreshListener() {
            @Override
            public void onRefresh(RefreshLayout refreshlayout) {
                mIndex = 1;
                onPullRefreshListener.onRefresh(mIndex);
            }
        });

        mSmartRefreshLayoutView.setOnLoadmoreListener(new OnLoadmoreListener() {
            @Override
            public void onLoadmore(RefreshLayout refreshlayout) {
                mIndex++;
                onPullRefreshListener.onLoadMore(mIndex);
            }
        });
    }

    public interface OnPullRefreshListener {
        void onRefresh(int index);

        void onLoadMore(int index);
    }

}
