package com.kangxin.common.framework;

import android.content.Context;
import android.os.Environment;
import android.util.Log;

import androidx.core.content.ContextCompat;

import com.kangxin.common.R;
import com.kangxin.common.imageloader.GalleryImageLoader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import cn.finalteam.galleryfinal.CoreConfig;
import cn.finalteam.galleryfinal.FunctionConfig;
import cn.finalteam.galleryfinal.GalleryFinal;
import cn.finalteam.galleryfinal.ThemeConfig;
import cn.finalteam.galleryfinal.model.PhotoInfo;


public class GalleryFinalSelector implements ImageSelector {

    public static final int REQUEST_CODE_GALLERY = 0x1510;
    public static final int REQUEST_CODE_CAMERA = 0x1511;

    String TAG = "GalleryFinalSelector";

    @Override
    public void init(Context context) {
        //设置主题
//ThemeConfig.CYAN
        ThemeConfig theme = new ThemeConfig.Builder()
                .setTitleBarBgColor(ContextCompat.getColor(context, R.color.colorPrimary))
                .setCheckSelectedColor(ContextCompat.getColor(context, R.color.colorPrimary))
                .setFabNornalColor(ContextCompat.getColor(context, R.color.colorPrimary))
                .setFabPressedColor(ContextCompat.getColor(context, R.color.colorPrimary))
                .build();
//配置功能
        FunctionConfig functionConfig = new FunctionConfig.Builder()
                .setEnableCamera(true)
                .setEnableEdit(false)
                .setEnableCrop(false)
                .setEnableRotate(false)
                .setCropSquare(true)
                .setEnablePreview(false)
                .build();

        String sdcard = Environment.getExternalStorageDirectory().getPath();
        File file = new File(sdcard + "/DCIM/");
//配置imageloader
        GalleryImageLoader imageloader = new GalleryImageLoader();
        CoreConfig coreConfig = new CoreConfig.Builder(context, imageloader, theme)
                .setFunctionConfig(functionConfig)
                .setTakePhotoFolder(file)
                .build();
        GalleryFinal.init(coreConfig);
    }

    @Override
    public void openCameraSingle(OnImageSelectedListener listener) {

        GalleryFinal.openCamera(REQUEST_CODE_CAMERA, new GalleryFinal.OnHanlderResultCallback() {
            @Override
            public void onHanlderSuccess(int reqeustCode, List<PhotoInfo> resultList) {
                if (listener != null) {
                    if (resultList != null && resultList.size() > 0) {
                        String photoPath = resultList.get(0).getPhotoPath();
                        listener.onSelectedImages(photoPath);
                    } else {
                        Log.e(TAG, "图片获取失败了，可能是没有选择图片吧");
                    }
                } else {
                    Log.e(TAG, "事件监听为null 有点问题");
                }
            }

            @Override
            public void onHanlderFailure(int requestCode, String errorMsg) {
                Log.e(TAG, "errorMsg");
            }
        });
    }


    @Override
    public void openAlbumSingle(OnImageSelectedListener listener) {
        GalleryFinal.openGallerySingle(REQUEST_CODE_GALLERY, new GalleryFinal.OnHanlderResultCallback() {
            @Override
            public void onHanlderSuccess(int reqeustCode, List<PhotoInfo> resultList) {
                if (listener != null) {
                    if (resultList != null && resultList.size() > 0) {
                        String photoPath = resultList.get(0).getPhotoPath();
                        listener.onSelectedImages(photoPath);
                    } else {
                        Log.e(TAG, "图片获取失败了，可能是没有选择图片吧");
                    }
                } else {
                    Log.e(TAG, "事件监听为null 有点问题");
                }
            }

            @Override
            public void onHanlderFailure(int requestCode, String errorMsg) {
                Log.e(TAG, "errorMsg");
            }
        });

    }

    @Override
    public void openAlbumMany(OnImagesSelectedListener listener) {
        final boolean[] isClickSelbtn = {false};
        GalleryFinal.openGalleryMuti(REQUEST_CODE_GALLERY, 9, new GalleryFinal.OnHanlderResultCallback() {
            @Override
            public void onHanlderSuccess(int reqeustCode, List<PhotoInfo> resultList) {
                if (listener != null) {
                    if (resultList != null && resultList.size() > 0) {
                        if (!isClickSelbtn[0]) {
                            ArrayList<String> images = new ArrayList<>();
                            for (PhotoInfo info : resultList) {
                                images.add(info.getPhotoPath());
                            }
                            listener.onSelectedImages(images);
                            isClickSelbtn[0] = true;
                        }
                    } else {
                        Log.e(TAG, "图片获取失败了，可能是没有选择图片吧");
                    }
                } else {
                    Log.e(TAG, "事件监听为null 有点问题");
                }
            }

            @Override
            public void onHanlderFailure(int requestCode, String errorMsg) {
                Log.e(TAG, "errorMsg");
            }
        });
    }
}
