package com.kangxin.common.framework;

import android.app.Activity;
import android.content.Context;

import androidx.fragment.app.Fragment;

import java.util.List;

public interface ImageSelector {

    @Deprecated
    void init(Context context);

    default void init(Fragment fragment) {
    }

    default void init(Activity fragment) {
    }

    /**
     * 打开相册,选取一张
     */
    @Deprecated
    void openCameraSingle(OnImageSelectedListener listener);

    default void openCamera(Fragment fragment, OnImageSelectedListener listener) {
    }

    default void openCamera(Activity fragment, OnImageSelectedListener listener) {
    }

    /***
     * 打开相机，选取单张
     */
    void openAlbumSingle(OnImageSelectedListener listener);

    /***
     * 打开相机，选取多张
     */
    void openAlbumMany(OnImagesSelectedListener listener);

    interface OnImagesSelectedListener {
        void onSelectedImages(List<String> images);
    }

    interface OnImageSelectedListener {
        void onSelectedImages(String image);
    }

}
