package com.kangxin.common.framework;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.util.Log;

import androidx.fragment.app.Fragment;

import com.kangxin.common.framework.photoSelect.GlideCacheEngine;
import com.kangxin.common.framework.photoSelect.GlideEngine;
import com.luck.picture.lib.PictureSelectionModel;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureConfig;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnResultCallbackListener;

import java.util.ArrayList;
import java.util.List;

public class PictureSelectorImpl implements ImageSelector {

    private static final String TAG = "PictureSelectorImpl";
    /**
     * 最大图片选择数量
     */
    private static final int MAX_SELNUM = 9;
    /**
     * 最小选择数量
     */
    private static final int MIX_SELNUM = 1;
    /**
     * 每行显示个数
     */
    private static final int COLUM_SHOWNUM = 4;
    /**
     * 裁剪输出质量
     */
    private static final int CLIP_OUTQUALITY = 90;
    /**
     * 小于一定大小的图片不压缩
     */
    private static final int MINI_COMPSIZE = 100;
    private PictureSelectionModel mPicSelector;

    @Override
    public void init(Activity activity) {
        // 进入相册 以下是例子：不需要的api可以不写
        mPicSelector = PictureSelector.create(activity)
                .openGallery(PictureMimeType.ofImage())// 全部.PictureMimeType.ofAll()、图片.ofImage()、视频.ofVideo()、音频.ofAudio()
                .loadImageEngine(GlideEngine.createGlideEngine())// 外部传入图片加载引擎，必传项
                .loadCacheResourcesCallback(GlideCacheEngine.createCacheEngine())// 获取图片资源缓存，主要是解决华为10部分机型在拷贝文件过多时会出现卡的问题，这里可以判断只在会出现一直转圈问题机型上使用
                .maxSelectNum(MAX_SELNUM)// 最大图片选择数量
                .minSelectNum(MIX_SELNUM)// 最小选择数量
//      .maxVideoSelectNum(maxSelectNum) // 视频最大选择数量，如果没有单独设置的需求则可以不设置，同用maxSelectNum字段
                .imageSpanCount(COLUM_SHOWNUM)// 每行显示个数
                .isReturnEmpty(false)// 未选择数据时点击按钮是否可以返回
                .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED)// 设置相册Activity方向，不设置默认使用系统
                .isSingleDirectReturn(true)// 单选模式下是否直接返回，PictureConfig.SINGLE模式下有效
                .previewVideo(true)// 是否可预览视频
                .isCamera(false)// 是否显示拍照按钮
                .isZoomAnim(true)// 图片列表点击 缩放效果 默认true
                .enableCrop(true)// 是否裁剪
                .compress(true)// 是否压缩
                //.compressQuality(80)// 图片压缩后输出质量 0~ 100
                .synOrAsy(true)//同步true或异步false 压缩 默认同步
//      .selectionMedia(mAdapter.getData())// 是否传入已选图片
                //.cropCompressQuality(90)// 注：已废弃 改用cutOutQuality()
                .cutOutQuality(CLIP_OUTQUALITY)// 裁剪输出质量 默认100
                .minimumCompressSize(MINI_COMPSIZE);// 小于100kb的图片不压缩

    }


    @Override
    public void init(Fragment fragment) {
        // 进入相册 以下是例子：不需要的api可以不写
        mPicSelector = PictureSelector.create(fragment)
                .openGallery(PictureMimeType.ofImage())// 全部.PictureMimeType.ofAll()、图片.ofImage()、视频.ofVideo()、音频.ofAudio()
                .loadImageEngine(GlideEngine.createGlideEngine())// 外部传入图片加载引擎，必传项
                .loadCacheResourcesCallback(GlideCacheEngine.createCacheEngine())// 获取图片资源缓存，主要是解决华为10部分机型在拷贝文件过多时会出现卡的问题，这里可以判断只在会出现一直转圈问题机型上使用
                .maxSelectNum(MAX_SELNUM)// 最大图片选择数量
                .minSelectNum(MIX_SELNUM)// 最小选择数量
//      .maxVideoSelectNum(maxSelectNum) // 视频最大选择数量，如果没有单独设置的需求则可以不设置，同用maxSelectNum字段
                .imageSpanCount(COLUM_SHOWNUM)// 每行显示个数
                .isReturnEmpty(false)// 未选择数据时点击按钮是否可以返回
                .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED)// 设置相册Activity方向，不设置默认使用系统
                .isSingleDirectReturn(true)// 单选模式下是否直接返回，PictureConfig.SINGLE模式下有效
                .previewVideo(true)// 是否可预览视频
                .isCamera(false)// 是否显示拍照按钮
                .isZoomAnim(true)// 图片列表点击 缩放效果 默认true
                .enableCrop(false)// 是否裁剪
                .compress(true)// 是否压缩
                //.compressQuality(80)// 图片压缩后输出质量 0~ 100
                .synOrAsy(true)//同步true或异步false 压缩 默认同步
//      .selectionMedia(mAdapter.getData())// 是否传入已选图片
                //.cropCompressQuality(90)// 注：已废弃 改用cutOutQuality()
                .cutOutQuality(CLIP_OUTQUALITY)// 裁剪输出质量 默认100
                .minimumCompressSize(MINI_COMPSIZE);// 小于100kb的图片不压缩
    }

    @Override
    public void init(Context context) {

    }

    @Deprecated
    @Override
    public void openCameraSingle(OnImageSelectedListener listener) {

    }

    @Override
    public void openCamera(Activity activity, OnImageSelectedListener listener) {
        PictureSelector.create(activity)
                .openCamera(PictureMimeType.ofImage())
                .loadImageEngine(GlideEngine.createGlideEngine())
                .compress(true)
                .forResult(new OnResultCallbackListener<LocalMedia>() {
                    @Override
                    public void onResult(List<LocalMedia> result) {
                        // onResult Callback
                        if (result != null && result.size() > 0) {
                            if (listener != null) {
                                listener.onSelectedImages(result.get(0).getCompressPath());
                            }
                        }
                    }

                    @Override
                    public void onCancel() {
                        // onCancel Callback
                    }
                });
    }


    @Override
    public void openCamera(Fragment fragment, OnImageSelectedListener listener) {
        PictureSelector.create(fragment)
                .openCamera(PictureMimeType.ofImage())
                .loadImageEngine(GlideEngine.createGlideEngine())
                .compress(true)
                .forResult(new OnResultCallbackListener<LocalMedia>() {
                    @Override
                    public void onResult(List<LocalMedia> result) {
                        // onResult Callback
                        if (result != null && result.size() > 0) {
                            if (listener != null) {
                                listener.onSelectedImages(result.get(0).getCompressPath());
                            }
                        }
                    }

                    @Override
                    public void onCancel() {
                        // onCancel Callback
                    }
                });
    }

    @Override
    public void openAlbumSingle(OnImageSelectedListener listener) {

        if (mPicSelector == null) {
            return;
        }

        mPicSelector.selectionMode(PictureConfig.SINGLE);// 多选 or 单选
        mPicSelector.forResult(new OnResultCallbackListener<LocalMedia>() {
            @Override
            public void onResult(List<LocalMedia> result) {
                List<String> pathList = new ArrayList<>();
                for (LocalMedia media : result) {
                    if (media.getCompressPath() != null) {
                        pathList.add(media.getCompressPath());
                    }
                }

                if (listener != null) {
                    if (!pathList.isEmpty()) {
                        listener.onSelectedImages(pathList.get(0));
                    }
                }
            }

            @Override
            public void onCancel() {
                Log.i(TAG, "PictureSelector Cancel");
            }
        });
    }

    @Override
    public void openAlbumMany(OnImagesSelectedListener listener) {
        if (mPicSelector == null) {
            return;
        }

        mPicSelector.selectionMode(PictureConfig.MULTIPLE);// 多选 or 单选
        mPicSelector.forResult(new OnResultCallbackListener<LocalMedia>() {
            @Override
            public void onResult(List<LocalMedia> result) {
                List<String> pathList = new ArrayList<>();
                for (LocalMedia media : result) {
                    if (media.getCompressPath() != null) {
                        pathList.add(media.getCompressPath());
                    }
                }

                if (listener != null) {
                    if (!pathList.isEmpty()) {
                        listener.onSelectedImages(pathList);
                    }
                }

            }

            @Override
            public void onCancel() {
                Log.i(TAG, "PictureSelector Cancel");
            }
        });
    }
}
