package com.kangxin.common.imageloader.factory;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;

import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.kangxin.common.imageloader.GlideApp;
import com.kangxin.common.imageloader.GlideRequest;
import com.kangxin.common.imageloader.ImageLoader;
import com.kangxin.common.imageloader.Style;

public class GlideImageLoader implements ImageLoader {

    RequestBuilder load;
    private Context mContext;

    public GlideImageLoader(Context mContext) {
        this.mContext = mContext;
    }


    @Override
    public ImageLoader loadImage(String url) {
        load = GlideApp.with(mContext)
                .load(url);
        return this;
    }

    @Override
    public ImageLoader bitmapTransform(int style) {
        RequestOptions options = new RequestOptions();
        switch (style) {
            case Style.NORMAL:
                options.dontTransform();
                break;
            case Style.CIRCLE:
                options.circleCrop();
                break;

        }
        load.apply(options);
        return this;
    }


    @Override
    public ImageLoader bitmapTransform(Transformation<Bitmap> transformation) {
        RequestOptions options = new RequestOptions();
        options.transform(transformation);
        load.apply(options);
        return this;
    }

    @Override
    public ImageLoader placeholder(int id) {
        if (load instanceof GlideRequest) {
            ((GlideRequest) load).placeholder(id);
        }
        return this;
    }


    @Override
    public ImageLoader transform(Transformation<Bitmap> transformation) {
        if (load instanceof GlideRequest) {
            ((GlideRequest) load).transform(transformation);
        }
        return this;
    }

    @Override
    public ImageLoader centerCrop() {
        if (load instanceof GlideRequest) {
            ((GlideRequest) load).centerCrop();

        }
        return this;
    }


    @Override
    public ImageLoader placeholder(Drawable drawable) {
        if (load instanceof GlideRequest) {
            ((GlideRequest) load).placeholder(drawable);
        }
        return this;
    }


    @Override
    public void into(ImageView target) {
        load.into(target);
    }

    @Override
    public ImageLoader err(int id) {
        if (load instanceof GlideRequest) {
            ((GlideRequest) load).error(id);
        }
        return this;
    }

    @Override
    public ImageLoader err(Drawable drawable) {
        if (load instanceof GlideRequest) {
            ((GlideRequest) load).error(drawable);
        }
        return this;
    }

    @Override
    public ImageLoader diskCacheStrategy(DiskCacheStrategy diskCacheStrategy) {
        if (load instanceof GlideRequest) {
            ((GlideRequest) load).diskCacheStrategy(diskCacheStrategy);
        }
        return this;
    }

    @Override
    public ImageLoader skipMemoryCache(boolean isCache) {
        if (load instanceof GlideRequest) {
            ((GlideRequest) load).skipMemoryCache(isCache);
        }
        return this;
    }

    @Override
    public ImageLoader sign(Key key) {
        if (load instanceof GlideRequest) {
            ((GlideRequest) load).signature(key);
        }
        return this;
    }
}
