package com.kangxin.common.util;

import android.app.ProgressDialog;
import android.content.Context;

import com.kangxin.common.R;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;

public class GlobeLoadingHelper {

    private static int loadingIndex = 0;

    private static ProgressDialog progressDialog;

    public static void show(Context mContext) {
        synchronized (GlobeLoadingHelper.class) {
            Observable.just(1)
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe(new Observer<Integer>() {
                        Disposable d;

                        @Override
                        public void onSubscribe(Disposable d) {
                            this.d = d;
                        }

                        @Override
                        public void onNext(Integer integer) {
                            d.dispose();
                            loadingIndex++;
                            if (progressDialog != null && progressDialog.isShowing())
                                return;

                            if(null == mContext)
                                return;

                            try {
                                progressDialog = new ProgressDialog(mContext, R.style.comm_loading_style);
                                progressDialog.setOnDismissListener(dialog -> loadingIndex = 0);
                                progressDialog.show();
                            }catch (Exception e){
                                
                            }
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        }
    }

    public static void dissmiss() {
        synchronized (GlobeLoadingHelper.class) {
            Observable.just(1)
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe(new Observer<Integer>() {
                        Disposable d;

                        @Override
                        public void onSubscribe(Disposable d) {
                            this.d = d;
                        }

                        @Override
                        public void onNext(Integer integer) {
                            d.dispose();
                            if (loadingIndex > 1) {
                                loadingIndex--;
                                return;
                            }
                            loadingIndex = 0;
                            if (progressDialog == null || !progressDialog.isShowing())
                                return;
                            try {
                                if (progressDialog.getContext() == null) {
                                    return;
                                }
                                progressDialog.dismiss();
                                progressDialog = null;
                            }catch (Exception e){

                            }
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        }
    }
}
