package com.kangxin.common.util;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;

import androidx.annotation.IdRes;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;

public class ListViewUtil {


    public static void setRecyclerViewHeight(RecyclerView recyclerView, @IdRes int itemViewId, int itemLimiteCount) {
        RecyclerView.Adapter recyclerAdapter = recyclerView.getAdapter();
        if (recyclerAdapter == null) {
            return;
        }

        if (recyclerAdapter instanceof BaseQuickAdapter) {
            int totalHeight = 0;
            for (int i = 0, len = recyclerAdapter.getItemCount(); i < len && (i < itemLimiteCount); i++) {
                View itemView = ((BaseQuickAdapter) recyclerAdapter).getViewByPosition(i, itemViewId);
                // 计算子项View 的宽高
                itemView.measure(0, 0);
                // 统计所有子项的总高度
                totalHeight += itemView.getMeasuredHeight();
            }

            ViewGroup.LayoutParams params = recyclerView.getLayoutParams();
            params.height = totalHeight + ((recyclerAdapter.getItemCount() - 1));
            // listView.getDividerHeight()获取子项间分隔符占用的高度
            // params.height最后得到整个ListView完整显示需要的高度
            recyclerView.setLayoutParams(params);
        }


    }

    /**
     * 根据子项及其要显示的数量来设置ListView的高度
     *
     * @param listView        需要显示的ListView
     * @param itemLimiteCount 需要ListView显示的Item数
     */
    public static void setListViewHeightBasedOnChildren(ListView listView, int itemLimiteCount) {
        // 获取ListView对应的Adapter
        ListAdapter listAdapter = (ListAdapter) listView.getAdapter();
        if (listAdapter == null) {
            return;
        }

        int totalHeight = 0;
        for (int i = 0, len = listAdapter.getCount(); i < len && (i < itemLimiteCount); i++) {
            // listAdapter.getCount()返回数据项的数目
            View listItem = listAdapter.getView(i, null, listView);
            // 计算子项View 的宽高
            listItem.measure(0, 0);
            // 统计所有子项的总高度
            totalHeight += listItem.getMeasuredHeight();
        }

        ViewGroup.LayoutParams params = listView.getLayoutParams();
        params.height = totalHeight + (listView.getDividerHeight() * (listAdapter.getCount() - 1));
        // listView.getDividerHeight()获取子项间分隔符占用的高度
        // params.height最后得到整个ListView完整显示需要的高度
        listView.setLayoutParams(params);
    }
}
