package com.kangxin.doctor.worktable.dialog;

import android.content.Context;
import android.view.Display;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;

import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

public class CenterHintDialog {


    private Context mContext;
    private String title;
    private String rightText = StringsUtils.getString(R.string.worktab_quxiazai);
    private String leftText = StringsUtils.getString(R.string.worktab_quxiao);
    private String message;
    private View.OnClickListener clickCancel;
    private View.OnClickListener clickOk;

    private Boolean touchOutCancel = true;

    private boolean isShowCancel = true;

    CenterHintDialog(Context mContext) {
        this.mContext = mContext;
    }

    public static CenterHintDialog with(Context mContext) {
        return new CenterHintDialog(mContext);
    }

    public CenterHintDialog setTitle(String title) {
        this.title = title;
        return this;
    }

    public CenterHintDialog setRightText(String rightText) {
        this.rightText = rightText;
        return this;
    }

    public CenterHintDialog setMesssage(String message) {
        this.message = message;
        return this;
    }

    public CenterHintDialog bindCancelClick(View.OnClickListener onClickListener) {
        this.clickCancel = onClickListener;
        return this;
    }

    public CenterHintDialog bindOkClick(View.OnClickListener onClickListener) {
        this.clickOk = onClickListener;
        return this;
    }

    public CenterHintDialog setShowCancel(boolean isShowCancel) {
        this.isShowCancel = isShowCancel;
        return this;
    }

    public CenterHintDialog setLeftText(String leftText) {
        this.leftText = leftText;
        return this;
    }


    public CenterHintDialog touchOutCancel(boolean isTouchCancel) {
        this.touchOutCancel = isTouchCancel;
        return this;
    }


    public void show() {
//
//        CenterHintDialogSpe centerHintDialogSpe =   new CenterHintDialogSpe(mContext,R.style.worktab_AlertDialogStyle);
//
//        centerHintDialogSpe
//                .bindLeftClick(clickCancel)
//                .bindRightClick(clickOk)
//                .setTouchOutCancel(touchOutCancel)
//                .setShowCancel(isShowCancel)
//                .setMessage(message)
//                .setLeftText(leftText)
//                .setTitle(title)
//                .setRightText(rightText)
//                .show();
        String left1 = "     ";
        final AlertDialog alertDialog = new AlertDialog.Builder(mContext, R.style.worktab_AlertDialogStyle).create();
        View rootView = View.inflate(mContext, R.layout.module_dialog_common_hint, null);

        Window dialogWindow = alertDialog.getWindow();
        WindowManager m = (WindowManager) mContext.getSystemService(Context.WINDOW_SERVICE);
        Display d = m.getDefaultDisplay(); // 获取屏幕宽、高用
        WindowManager.LayoutParams p = dialogWindow.getAttributes(); // 获取对话框当前的参数值
        p.width = (int) (d.getWidth() * 0.9); // 宽度设置为屏幕的0.65
        p.height = p.WRAP_CONTENT;
        dialogWindow.setGravity(Gravity.CENTER);
        TextView tipsContent = rootView.findViewById(R.id.tips_content);
        TextView tipsTitle = rootView.findViewById(R.id.tips_title);
        if (message.length()<10) {

            String content = left1+message+left1;
            tipsContent.setText(content);

        }else{
            tipsContent.setText(message);
        }
        tipsTitle.setText(title);
        TextView mOkBtnView = rootView.findViewById(R.id.mOkBtnView);
        mOkBtnView.setText(rightText);
        TextView mSignView = rootView.findViewById(R.id.mSignView);
        mSignView.setText(leftText);
        if(isShowCancel){
            mSignView.setVisibility(View.VISIBLE);
        }else{
            mSignView.setVisibility(View.GONE);
        }

        mOkBtnView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.dismiss();
                if (clickOk != null) {
                    clickOk.onClick(v);
                }
            }
        });

        mSignView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.dismiss();
                if (clickCancel != null) {
                    clickCancel .onClick(v);
                }
            }
        });


        alertDialog.setCanceledOnTouchOutside(touchOutCancel);
        alertDialog.setView(rootView);
        alertDialog.show();
        dialogWindow.setAttributes(p);


    }

}
