package com.kangxin.utils.upload;


import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.entity.UpImgEntity;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;

/**
 * @author mac
 */
public interface FileApi {

    /**
     * 上传单张图片
     */
    String UPLOAD_IMAGE = "/cloud/doctoruser/oss/api/file/store/v1/saveFile";


    /**
     * 上传多张图片
     */
    String UPLOAD_IMAGES = "/cloud/doctoruser/oss/api/file/store/v1/saveFiles";

    /**
     * 图片上传 单张
     *
     * @param imps
     * @param description
     * @return
     */
    @Multipart
    @POST(UPLOAD_IMAGE)
    @Headers("Content-Type: multipart/form-data")
    Call<ResponseBody<UpImgEntity>> uploadFile(@Part("description") RequestBody description, @Part MultipartBody.Part imps);

    @Multipart
    @POST(UPLOAD_IMAGE)
    Observable<ResponseBody<UpImgEntity>> uploadFile(@Part MultipartBody.Part imps);

    /**
     * 图片上传 多张
     *
     * @param files
     * @return
     */
    @Multipart
    @POST(UPLOAD_IMAGES)
    Observable<ResponseBody<List<UpImgEntity>>> uploadFiles(@Part List<MultipartBody.Part> files);

}
