package com.kangxin.utils.upload;

import android.util.Log;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BaseModel;
import com.kangxin.common.entity.UpImgEntity;
import com.kangxin.common.util.SchedulesSwitch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import io.reactivex.Observable;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class UpFileModule extends BaseModel implements IFileModule {

    private static final String TAG = "UpFileModule";

    @Override
    public Observable<ResponseBody<UpImgEntity>> uploadFile(File file) {
        Log.i(TAG, "uploadFile==>>file:" + file);

        RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
        MultipartBody.Part part = MultipartBody.Part.createFormData("file", file.getName(), requestFile);
        Log.i(TAG, "uploadFile==>>part:" + part);


        return createFitApi(FileApi.class).uploadFile(part)
                .compose(SchedulesSwitch.<ResponseBody<UpImgEntity>>applySchedulers());
    }

    @Override
    public Observable<ResponseBody<UpImgEntity>> uploadFile(String filePath) {

        return uploadFile(new File(filePath));
    }

    @Override
    public Observable<ResponseBody<List<UpImgEntity>>> uploadFiles(List<String> files) {


        ArrayList<MultipartBody.Part> list = new ArrayList<>();

        for (String filePath : files) {
            if (filePath.equals("")) {
                continue;
            }
            RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), new File(filePath));
            MultipartBody.Part part = MultipartBody.Part.createFormData("files", filePath, requestFile);
            list.add(part);
        }

        return createApi2(FileApi.class).uploadFiles(list).compose(SchedulesSwitch.applySchedulers());
    }


}
