/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.clientalg.util;

import cn.org.bjca.mssp.clientalg.android.ClientSecureAlg;
import cn.org.bjca.mssp.clientalg.util.EncodeUtil;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DERBitString;
import cn.org.bjca.mssp.msspjce.asn1.oiw.OIWObjectIdentifiers;
import cn.org.bjca.mssp.msspjce.asn1.pkcs.CertificationRequest;
import cn.org.bjca.mssp.msspjce.asn1.pkcs.CertificationRequestInfo;
import cn.org.bjca.mssp.msspjce.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;

public class ASymUtil {
    public static byte[] semSign(String alg, byte[] dsem, byte[] pub, byte[] tbs) throws Exception {
        if (alg.toLowerCase().endsWith("rsa")) {
            return ASymUtil.rsaSemSign(alg, dsem, pub, tbs);
        }
        if (alg.equalsIgnoreCase("sm2")) {
            return ASymUtil.sm2SemSign(dsem, tbs);
        }
        throw new RuntimeException("unsupport signalg:" + alg);
    }

    private static byte[] rsaSemSign(String alg, byte[] dsem, byte[] pub, byte[] tbs) throws Exception {
        String[] algs = alg.split("with");
        String hashAlg = algs[0];
        return ASymUtil.rsaSignHash(hashAlg, tbs, dsem, pub);
    }

    private static byte[] sm2SemSign(byte[] dsem, byte[] tbs) throws Exception {
        return new byte[0];
    }

    private static byte[] packDigestInfo(String alg, byte[] hash) {
        if (alg.equalsIgnoreCase("sha1")) {
            if (hash.length == 20) {
                byte[] sha1Head = EncodeUtil.bigInteger2ByteArray(new BigInteger("3021300906052b0e03021a05000414", 16));
                byte[] h = new byte[35];
                System.arraycopy(sha1Head, 0, h, 0, 15);
                System.arraycopy(hash, 0, h, 15, 20);
                return h;
            }
            if (hash.length == 35) {
                return hash;
            }
            throw new RuntimeException("hash length error,length=" + hash.length);
        }
        if (alg.equalsIgnoreCase("sha256")) {
            if (hash.length == 32) {
                byte[] sha1Head = EncodeUtil.bigInteger2ByteArray(new BigInteger("3031300d060960864801650304020105000420", 16));
                byte[] h = new byte[51];
                System.arraycopy(sha1Head, 0, h, 0, 19);
                System.arraycopy(hash, 0, h, 19, 32);
                return h;
            }
            if (hash.length == 51) {
                return hash;
            }
            throw new RuntimeException("hash length error,length=" + hash.length);
        }
        throw new RuntimeException("hash alg not support");
    }

    private static byte[] pkcs1EncodingForSign(byte[] t1, int keybits) {
        int rlen = t1.length;
        int flen = (keybits + 7) / 8 - 1;
        if (rlen >= flen) {
            throw new RuntimeException("input data to padding too long,keysize=" + flen + " , datalen=" + rlen);
        }
        byte[] block = new byte[flen];
        block[0] = 1;
        int i = 1;
        while (i != block.length - rlen - 1) {
            block[i] = -1;
            ++i;
        }
        block[block.length - rlen - 1] = 0;
        System.arraycopy(t1, 0, block, block.length - rlen, rlen);
        return block;
    }

    private static byte[] rsaSignHash(String hashAlg, byte[] hash, byte[] pri, byte[] pub) {
        PublicKey publicKey;
        X509EncodedKeySpec spec = new X509EncodedKeySpec(pub);
        try {
            publicKey = KeyFactory.getInstance("RSA").generatePublic(spec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        RSAPublicKey rsapub = (RSAPublicKey)publicKey;
        BigInteger n = rsapub.getModulus();
        int bits = n.bitLength();
        if (hashAlg.equalsIgnoreCase("sha1")) {
            byte[] sha1data = null;
            if (hash.length != 20 && hash.length != 35) {
                throw new RuntimeException("sha1 hash length must  20");
            }
            if (hash.length == 20) {
                sha1data = hash;
            } else if (hash.length == 35) {
                sha1data = new byte[20];
                System.arraycopy(hash, 15, sha1data, 0, 20);
            }
            return ClientSecureAlg.clientSHA1withRSA(pri, pub, sha1data, bits);
        }
        if (hashAlg.equalsIgnoreCase("sha256")) {
            byte[] sha256data = null;
            if (hash.length != 32 && hash.length != 51) {
                throw new RuntimeException("sha1 hash length must  20");
            }
            if (hash.length == 32) {
                sha256data = hash;
            } else if (hash.length == 51) {
                sha256data = new byte[32];
                System.arraycopy(hash, 19, sha256data, 0, 32);
            }
            return ClientSecureAlg.clientSHA256withRSA(pri, pub, sha256data, bits);
        }
        throw new RuntimeException("hashalg must use sha1 or sha256,now is " + hashAlg);
    }

    public static byte[] combileRSASign(byte[] cs, byte[] ss, byte[] pub) {
        return ClientSecureAlg.combineRSASign(cs, ss, pub);
    }

    public static byte[] packCertReq(byte[] tbs, byte[] signedData) throws Exception {
        ASN1Sequence asq = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])tbs);
        CertificationRequestInfo cri = new CertificationRequestInfo(asq);
        CertificationRequest cr = new CertificationRequest(cri, new AlgorithmIdentifier(OIWObjectIdentifiers.sha1WithRSA), new DERBitString(signedData));
        return cr.getEncoded();
    }
}

