/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.clientalg.util;

import cn.org.bjca.mssp.clientalg.android.ClientSecureAlg;
import cn.org.bjca.mssp.clientalg.util.EncodeUtil;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DERBitString;
import cn.org.bjca.mssp.msspjce.asn1.pkcs.CertificationRequest;
import cn.org.bjca.mssp.msspjce.asn1.pkcs.CertificationRequestInfo;
import cn.org.bjca.mssp.msspjce.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.x9.X962NamedCurves;
import cn.org.bjca.mssp.msspjce.asn1.x9.X9ECParameters;
import cn.org.bjca.mssp.msspjce.asn1.x9.X9ObjectIdentifiers;
import cn.org.bjca.mssp.msspjce.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.jcajce.provider.asymmetric.util.ECUtil;
import cn.org.bjca.mssp.msspjce.jcajce.provider.asymmetric.util.SM2Util;
import cn.org.bjca.mssp.msspjce.jce.provider.MSSPProvider;
import cn.org.bjca.mssp.msspjce.jce.spec.ECNamedCurveParameterSpec;
import cn.org.bjca.mssp.msspjce.jce.spec.ECParameterSpec;
import cn.org.bjca.mssp.msspjce.jce.spec.ECPublicKeySpec;
import cn.org.bjca.mssp.msspjce.math.ec.ECCurve;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;

public class SEMSM2Util {
    static X9ECParameters param = X962NamedCurves.getByName((String)"prime256v1_sm2");
    static ECCurve curve = param.getCurve();
    static ECPoint G = param.getG();
    static BigInteger n = param.getN();

    static {
        Security.addProvider((Provider)new MSSPProvider());
    }

    public static BigInteger genRandom(int bytes) {
        BigInteger d = BigInteger.ZERO;
        while ((d = new BigInteger(bytes * 8, new SecureRandom())).equals(BigInteger.ZERO) || d.compareTo(n) >= 0) {
        }
        return d;
    }

    public static byte[] generateSEMSM2PrivateKey() {
        BigInteger d = BigInteger.ZERO;
        while ((d = new BigInteger(256, new SecureRandom())).equals(BigInteger.ZERO) || d.compareTo(n) >= 0) {
        }
        return EncodeUtil.bigInteger2ByteArray(d);
    }

    public static PublicKey point2PublicKey(ECPoint p) throws Exception {
        ECNamedCurveParameterSpec spec2 = new ECNamedCurveParameterSpec("prime256v1_sm2", curve, G, param.getN());
        ECPublicKeySpec spec = new ECPublicKeySpec(p, (ECParameterSpec)spec2);
        PublicKey pub = KeyFactory.getInstance("EC").generatePublic((KeySpec)spec);
        return pub;
    }

    public static ECPoint pack2Point(byte[] data) throws Exception {
        return curve.decodePoint(data);
    }

    public static byte[] generateSM2PublicKeyPoint(byte[] d) {
        return ClientSecureAlg.calcClientSM2PublicFactor(d);
    }

    public static byte[] calckG(byte[] k) {
        return ClientSecureAlg.calcPoint4Sign(k);
    }

    public static byte[] calcP(byte[] dc, byte[] ps) {
        return ClientSecureAlg.calcFullPublic(dc, ps);
    }

    public static PublicKey toPublicKey(byte[] ecPub) throws Exception {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(ecPub);
        PublicKey pub = KeyFactory.getInstance("EC", "MSSP").generatePublic(spec);
        return pub;
    }

    public static ECPoint getPoint(PublicKey pub) throws Exception {
        AsymmetricKeyParameter param2 = ECUtil.generatePublicKeyParameter((PublicKey)pub);
        ECPublicKeyParameters key = (ECPublicKeyParameters)param2;
        ECPoint P = key.getQ();
        return P;
    }

    public static byte[] clientSemSign(byte[] br, byte[] bs2, byte[] bs3, byte[] bk1, byte[] bd1) {
        return ClientSecureAlg.combineSM2Sign(br, bs2, bs3, bk1, bd1);
    }

    public static byte[] packCertReq(byte[] tbs, byte[] signedData) throws Exception {
        ASN1Sequence asq = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])tbs);
        CertificationRequestInfo cri = new CertificationRequestInfo(asq);
        CertificationRequest cr = new CertificationRequest(cri, new AlgorithmIdentifier(X9ObjectIdentifiers.sm2_with_SM3), new DERBitString(signedData));
        return cr.getEncoded();
    }

    public static boolean verify(PublicKey pub, byte[] signed, byte[] hash) throws Exception {
        return SM2Util.verify((PublicKey)pub, (byte[])signed, (byte[])hash);
    }

    public static byte[] sm3ForSM2(PublicKey pub, byte[] data) throws Exception {
        ECPoint P = SEMSM2Util.getPoint(pub);
        return SM2Util.SM3ForSignature((byte[])data, (ECPoint)P);
    }

    public static byte[][] semsign2(byte[] Q1, byte[] dc, byte[] e) throws Exception {
        byte[] k2 = SEMSM2Util.genRandom(32).toByteArray();
        byte[] k3 = SEMSM2Util.genRandom(32).toByteArray();
        System.out.println("k2 : " + EncodeUtil.base64Encode(k2));
        System.out.println("k3: " + EncodeUtil.base64Encode(k3));
        byte[] rs = ClientSecureAlg.semsign2(Q1, dc, e, k2, k3);
        byte[] ar = new byte[33];
        System.arraycopy(rs, 0, ar, 0, 33);
        byte[] as2 = new byte[33];
        System.arraycopy(rs, 33, as2, 0, 33);
        byte[] as3 = new byte[33];
        System.arraycopy(rs, 66, as3, 0, 33);
        return new byte[][]{new BigInteger(1, ar).toByteArray(), new BigInteger(1, as2).toByteArray(), new BigInteger(1, as3).toByteArray()};
    }
}

