/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.cmp;

import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.ASN1TaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.asn1.DERTaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.cmp.CMPCertificate;
import cn.org.bjca.mssp.msspjce.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Object {
    private ASN1Sequence caPubs;
    private ASN1Sequence response;

    private CertRepMessage(ASN1Sequence seq) {
        int index = 0;
        if (seq.size() > 1) {
            this.caPubs = ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(index++), true);
        }
        this.response = ASN1Sequence.getInstance(seq.getObjectAt(index));
    }

    public static CertRepMessage getInstance(Object o) {
        if (o instanceof CertRepMessage) {
            return (CertRepMessage)o;
        }
        if (o != null) {
            return new CertRepMessage(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public CertRepMessage(CMPCertificate[] caPubs, CertResponse[] response) {
        int i;
        ASN1EncodableVector v;
        if (response == null) {
            throw new IllegalArgumentException("'response' cannot be null");
        }
        if (caPubs != null) {
            v = new ASN1EncodableVector();
            i = 0;
            while (i < caPubs.length) {
                v.add(caPubs[i]);
                ++i;
            }
            this.caPubs = new DERSequence(v);
        }
        v = new ASN1EncodableVector();
        i = 0;
        while (i < response.length) {
            v.add(response[i]);
            ++i;
        }
        this.response = new DERSequence(v);
    }

    public CMPCertificate[] getCaPubs() {
        if (this.caPubs == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.caPubs.size()];
        int i = 0;
        while (i != results.length) {
            results[i] = CMPCertificate.getInstance(this.caPubs.getObjectAt(i));
            ++i;
        }
        return results;
    }

    public CertResponse[] getResponse() {
        CertResponse[] results = new CertResponse[this.response.size()];
        int i = 0;
        while (i != results.length) {
            results[i] = CertResponse.getInstance(this.response.getObjectAt(i));
            ++i;
        }
        return results;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.caPubs != null) {
            v.add(new DERTaggedObject(true, 1, this.caPubs));
        }
        v.add(this.response);
        return new DERSequence(v);
    }
}

