/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.cmp;

import cn.org.bjca.mssp.msspjce.asn1.ASN1Encodable;
import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Integer;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1OctetString;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.ASN1TaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.DERGeneralizedTime;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.asn1.DERTaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.cmp.InfoTypeAndValue;
import cn.org.bjca.mssp.msspjce.asn1.cmp.PKIFreeText;
import cn.org.bjca.mssp.msspjce.asn1.x500.X500Name;
import cn.org.bjca.mssp.msspjce.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.x509.GeneralName;
import java.util.Enumeration;

public class PKIHeader
extends ASN1Object {
    public static final GeneralName NULL_NAME = new GeneralName(X500Name.getInstance(new DERSequence()));
    public static final int CMP_1999 = 1;
    public static final int CMP_2000 = 2;
    private ASN1Integer pvno;
    private GeneralName sender;
    private GeneralName recipient;
    private DERGeneralizedTime messageTime;
    private AlgorithmIdentifier protectionAlg;
    private ASN1OctetString senderKID;
    private ASN1OctetString recipKID;
    private ASN1OctetString transactionID;
    private ASN1OctetString senderNonce;
    private ASN1OctetString recipNonce;
    private PKIFreeText freeText;
    private ASN1Sequence generalInfo;

    private PKIHeader(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.pvno = ASN1Integer.getInstance(en.nextElement());
        this.sender = GeneralName.getInstance(en.nextElement());
        this.recipient = GeneralName.getInstance(en.nextElement());
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            switch (tObj.getTagNo()) {
                case 0: {
                    this.messageTime = DERGeneralizedTime.getInstance(tObj, true);
                    break;
                }
                case 1: {
                    this.protectionAlg = AlgorithmIdentifier.getInstance(tObj, true);
                    break;
                }
                case 2: {
                    this.senderKID = ASN1OctetString.getInstance(tObj, true);
                    break;
                }
                case 3: {
                    this.recipKID = ASN1OctetString.getInstance(tObj, true);
                    break;
                }
                case 4: {
                    this.transactionID = ASN1OctetString.getInstance(tObj, true);
                    break;
                }
                case 5: {
                    this.senderNonce = ASN1OctetString.getInstance(tObj, true);
                    break;
                }
                case 6: {
                    this.recipNonce = ASN1OctetString.getInstance(tObj, true);
                    break;
                }
                case 7: {
                    this.freeText = PKIFreeText.getInstance(tObj, true);
                    break;
                }
                case 8: {
                    this.generalInfo = ASN1Sequence.getInstance(tObj, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag number: " + tObj.getTagNo());
                }
            }
        }
    }

    public static PKIHeader getInstance(Object o) {
        if (o instanceof PKIHeader) {
            return (PKIHeader)o;
        }
        if (o != null) {
            return new PKIHeader(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public PKIHeader(int pvno, GeneralName sender, GeneralName recipient) {
        this(new ASN1Integer(pvno), sender, recipient);
    }

    private PKIHeader(ASN1Integer pvno, GeneralName sender, GeneralName recipient) {
        this.pvno = pvno;
        this.sender = sender;
        this.recipient = recipient;
    }

    public ASN1Integer getPvno() {
        return this.pvno;
    }

    public GeneralName getSender() {
        return this.sender;
    }

    public GeneralName getRecipient() {
        return this.recipient;
    }

    public DERGeneralizedTime getMessageTime() {
        return this.messageTime;
    }

    public AlgorithmIdentifier getProtectionAlg() {
        return this.protectionAlg;
    }

    public ASN1OctetString getSenderKID() {
        return this.senderKID;
    }

    public ASN1OctetString getRecipKID() {
        return this.recipKID;
    }

    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    public ASN1OctetString getSenderNonce() {
        return this.senderNonce;
    }

    public ASN1OctetString getRecipNonce() {
        return this.recipNonce;
    }

    public PKIFreeText getFreeText() {
        return this.freeText;
    }

    public InfoTypeAndValue[] getGeneralInfo() {
        if (this.generalInfo == null) {
            return null;
        }
        InfoTypeAndValue[] results = new InfoTypeAndValue[this.generalInfo.size()];
        int i = 0;
        while (i < results.length) {
            results[i] = InfoTypeAndValue.getInstance(this.generalInfo.getObjectAt(i));
            ++i;
        }
        return results;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.pvno);
        v.add(this.sender);
        v.add(this.recipient);
        this.addOptional(v, 0, this.messageTime);
        this.addOptional(v, 1, this.protectionAlg);
        this.addOptional(v, 2, this.senderKID);
        this.addOptional(v, 3, this.recipKID);
        this.addOptional(v, 4, this.transactionID);
        this.addOptional(v, 5, this.senderNonce);
        this.addOptional(v, 6, this.recipNonce);
        this.addOptional(v, 7, this.freeText);
        this.addOptional(v, 8, this.generalInfo);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

