/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.cmp;

import cn.org.bjca.mssp.msspjce.asn1.ASN1Encodable;
import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.ASN1TaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.DERBitString;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.asn1.DERTaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.cmp.CMPCertificate;
import cn.org.bjca.mssp.msspjce.asn1.cmp.PKIBody;
import cn.org.bjca.mssp.msspjce.asn1.cmp.PKIHeader;
import java.util.Enumeration;

public class PKIMessage
extends ASN1Object {
    private PKIHeader header;
    private PKIBody body;
    private DERBitString protection;
    private ASN1Sequence extraCerts;

    private PKIMessage(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.header = PKIHeader.getInstance(en.nextElement());
        this.body = PKIBody.getInstance(en.nextElement());
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            if (tObj.getTagNo() == 0) {
                this.protection = DERBitString.getInstance(tObj, true);
                continue;
            }
            this.extraCerts = ASN1Sequence.getInstance(tObj, true);
        }
    }

    public static PKIMessage getInstance(Object o) {
        if (o instanceof PKIMessage) {
            return (PKIMessage)o;
        }
        if (o != null) {
            return new PKIMessage(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public PKIMessage(PKIHeader header, PKIBody body, DERBitString protection, CMPCertificate[] extraCerts) {
        this.header = header;
        this.body = body;
        this.protection = protection;
        if (extraCerts != null) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            int i = 0;
            while (i < extraCerts.length) {
                v.add(extraCerts[i]);
                ++i;
            }
            this.extraCerts = new DERSequence(v);
        }
    }

    public PKIMessage(PKIHeader header, PKIBody body, DERBitString protection) {
        this(header, body, protection, null);
    }

    public PKIMessage(PKIHeader header, PKIBody body) {
        this(header, body, null, null);
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    public DERBitString getProtection() {
        return this.protection;
    }

    public CMPCertificate[] getExtraCerts() {
        if (this.extraCerts == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.extraCerts.size()];
        int i = 0;
        while (i < results.length) {
            results[i] = CMPCertificate.getInstance(this.extraCerts.getObjectAt(i));
            ++i;
        }
        return results;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.header);
        v.add(this.body);
        this.addOptional(v, 0, this.protection);
        this.addOptional(v, 1, this.extraCerts);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

