/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.cmp;

import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.asn1.cmp.PKIMessage;

public class PKIMessages
extends ASN1Object {
    private ASN1Sequence content;

    private PKIMessages(ASN1Sequence seq) {
        this.content = seq;
    }

    public static PKIMessages getInstance(Object o) {
        if (o instanceof PKIMessages) {
            return (PKIMessages)o;
        }
        if (o != null) {
            return new PKIMessages(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public PKIMessages(PKIMessage msg) {
        this.content = new DERSequence(msg);
    }

    public PKIMessages(PKIMessage[] msgs) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < msgs.length) {
            v.add(msgs[i]);
            ++i;
        }
        this.content = new DERSequence(v);
    }

    public PKIMessage[] toPKIMessageArray() {
        PKIMessage[] result = new PKIMessage[this.content.size()];
        int i = 0;
        while (i != result.length) {
            result[i] = PKIMessage.getInstance(this.content.getObjectAt(i));
            ++i;
        }
        return result;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.content;
    }
}

