/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.cms;

import cn.org.bjca.mssp.msspjce.asn1.ASN1Choice;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Encodable;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Integer;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.ASN1TaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.DERTaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.cms.KEKRecipientInfo;
import cn.org.bjca.mssp.msspjce.asn1.cms.KeyAgreeRecipientInfo;
import cn.org.bjca.mssp.msspjce.asn1.cms.KeyTransRecipientInfo;
import cn.org.bjca.mssp.msspjce.asn1.cms.OtherRecipientInfo;
import cn.org.bjca.mssp.msspjce.asn1.cms.PasswordRecipientInfo;

public class RecipientInfo
extends ASN1Object
implements ASN1Choice {
    ASN1Encodable info;

    public RecipientInfo(KeyTransRecipientInfo info) {
        this.info = info;
    }

    public RecipientInfo(KeyAgreeRecipientInfo info) {
        this.info = new DERTaggedObject(false, 1, info);
    }

    public RecipientInfo(KEKRecipientInfo info) {
        this.info = new DERTaggedObject(false, 2, info);
    }

    public RecipientInfo(PasswordRecipientInfo info) {
        this.info = new DERTaggedObject(false, 3, info);
    }

    public RecipientInfo(OtherRecipientInfo info) {
        this.info = new DERTaggedObject(false, 4, info);
    }

    public RecipientInfo(ASN1Primitive info) {
        this.info = info;
    }

    public static RecipientInfo getInstance(Object o) {
        if (o == null || o instanceof RecipientInfo) {
            return (RecipientInfo)o;
        }
        if (o instanceof ASN1Sequence) {
            return new RecipientInfo((ASN1Sequence)o);
        }
        if (o instanceof ASN1TaggedObject) {
            return new RecipientInfo((ASN1TaggedObject)o);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o.getClass().getName());
    }

    public ASN1Integer getVersion() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject o = (ASN1TaggedObject)this.info;
            switch (o.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(o, false).getVersion();
                }
                case 2: {
                    return this.getKEKInfo(o).getVersion();
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(o, false).getVersion();
                }
                case 4: {
                    return new ASN1Integer(0L);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info).getVersion();
    }

    public boolean isTagged() {
        return this.info instanceof ASN1TaggedObject;
    }

    public ASN1Encodable getInfo() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject o = (ASN1TaggedObject)this.info;
            switch (o.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(o, false);
                }
                case 2: {
                    return this.getKEKInfo(o);
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(o, false);
                }
                case 4: {
                    return OtherRecipientInfo.getInstance(o, false);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info);
    }

    private KEKRecipientInfo getKEKInfo(ASN1TaggedObject o) {
        if (o.isExplicit()) {
            return KEKRecipientInfo.getInstance(o, true);
        }
        return KEKRecipientInfo.getInstance(o, false);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.info.toASN1Primitive();
    }
}

