/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.eac;

import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.ASN1ParsingException;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DERApplicationSpecific;
import cn.org.bjca.mssp.msspjce.asn1.DEROctetString;
import cn.org.bjca.mssp.msspjce.asn1.eac.CertificateBody;
import cn.org.bjca.mssp.msspjce.asn1.eac.PublicKeyDataObject;
import java.io.IOException;
import java.util.Enumeration;

public class CVCertificateRequest
extends ASN1Object {
    private CertificateBody certificateBody;
    private byte[] innerSignature = null;
    private byte[] outerSignature = null;
    private int valid;
    private static int bodyValid = 1;
    private static int signValid = 2;
    ASN1ObjectIdentifier signOid = null;
    ASN1ObjectIdentifier keyOid = null;
    public static byte[] ZeroArray = new byte[1];
    String strCertificateHolderReference;
    byte[] encodedAuthorityReference;
    int ProfileId;
    byte[] certificate = null;
    protected String overSignerReference = null;
    byte[] encoded;
    PublicKeyDataObject iso7816PubKey = null;

    private CVCertificateRequest(DERApplicationSpecific request) throws IOException {
        if (request.getApplicationTag() == 103) {
            ASN1Sequence seq = ASN1Sequence.getInstance(request.getObject(16));
            this.initCertBody(DERApplicationSpecific.getInstance(seq.getObjectAt(0)));
            this.outerSignature = DERApplicationSpecific.getInstance(seq.getObjectAt(seq.size() - 1)).getContents();
        } else {
            this.initCertBody(request);
        }
    }

    private void initCertBody(DERApplicationSpecific request) throws IOException {
        if (request.getApplicationTag() == 33) {
            ASN1Sequence seq = ASN1Sequence.getInstance(request.getObject(16));
            Enumeration en = seq.getObjects();
            while (en.hasMoreElements()) {
                DERApplicationSpecific obj = DERApplicationSpecific.getInstance(en.nextElement());
                switch (obj.getApplicationTag()) {
                    case 78: {
                        this.certificateBody = CertificateBody.getInstance(obj);
                        this.valid |= bodyValid;
                        break;
                    }
                    case 55: {
                        this.innerSignature = obj.getContents();
                        this.valid |= signValid;
                        break;
                    }
                    default: {
                        throw new IOException("Invalid tag, not an CV Certificate Request element:" + obj.getApplicationTag());
                    }
                }
            }
        } else {
            throw new IOException("not a CARDHOLDER_CERTIFICATE in request:" + request.getApplicationTag());
        }
    }

    public static CVCertificateRequest getInstance(Object obj) {
        if (obj instanceof CVCertificateRequest) {
            return (CVCertificateRequest)obj;
        }
        if (obj != null) {
            try {
                return new CVCertificateRequest(DERApplicationSpecific.getInstance(obj));
            }
            catch (IOException e) {
                throw new ASN1ParsingException("unable to parse data: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public CertificateBody getCertificateBody() {
        return this.certificateBody;
    }

    public PublicKeyDataObject getPublicKey() {
        return this.certificateBody.getPublicKey();
    }

    public byte[] getInnerSignature() {
        return this.innerSignature;
    }

    public byte[] getOuterSignature() {
        return this.outerSignature;
    }

    public boolean hasOuterSignature() {
        return this.outerSignature != null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.certificateBody);
        try {
            v.add(new DERApplicationSpecific(false, 55, new DEROctetString(this.innerSignature)));
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to convert signature!");
        }
        return new DERApplicationSpecific(33, v);
    }
}

