/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.eac;

import cn.org.bjca.mssp.msspjce.util.Arrays;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class PackedDate {
    private byte[] time;

    public PackedDate(String time) {
        this.time = this.convert(time);
    }

    public PackedDate(Date time) {
        SimpleDateFormat dateF = new SimpleDateFormat("yyMMdd'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = this.convert(dateF.format(time));
    }

    private byte[] convert(String sTime) {
        char[] digs = sTime.toCharArray();
        byte[] date = new byte[6];
        int i = 0;
        while (i != 6) {
            date[i] = (byte)(digs[i] - 48);
            ++i;
        }
        return date;
    }

    PackedDate(byte[] bytes) {
        this.time = bytes;
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMdd");
        return dateF.parse("20" + this.toString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.time);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PackedDate)) {
            return false;
        }
        PackedDate other = (PackedDate)o;
        return Arrays.areEqual(this.time, other.time);
    }

    public String toString() {
        char[] dateC = new char[this.time.length];
        int i = 0;
        while (i != dateC.length) {
            dateC[i] = (char)((this.time[i] & 0xFF) + 48);
            ++i;
        }
        return new String(dateC);
    }

    public byte[] getEncoding() {
        return this.time;
    }
}

