/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.esf;

import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.asn1.DERTaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.esf.OtherRevVals;
import cn.org.bjca.mssp.msspjce.asn1.ocsp.BasicOCSPResponse;
import cn.org.bjca.mssp.msspjce.asn1.x509.CertificateList;
import java.util.Enumeration;

public class RevocationValues
extends ASN1Object {
    private ASN1Sequence crlVals;
    private ASN1Sequence ocspVals;
    private OtherRevVals otherRevVals;

    public static RevocationValues getInstance(Object obj) {
        if (obj instanceof RevocationValues) {
            return (RevocationValues)obj;
        }
        if (obj != null) {
            return new RevocationValues(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private RevocationValues(ASN1Sequence seq) {
        if (seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject o = (DERTaggedObject)e.nextElement();
            switch (o.getTagNo()) {
                case 0: {
                    ASN1Sequence crlValsSeq = (ASN1Sequence)o.getObject();
                    Enumeration crlValsEnum = crlValsSeq.getObjects();
                    while (crlValsEnum.hasMoreElements()) {
                        CertificateList.getInstance(crlValsEnum.nextElement());
                    }
                    this.crlVals = crlValsSeq;
                    break;
                }
                case 1: {
                    ASN1Sequence ocspValsSeq = (ASN1Sequence)o.getObject();
                    Enumeration ocspValsEnum = ocspValsSeq.getObjects();
                    while (ocspValsEnum.hasMoreElements()) {
                        BasicOCSPResponse.getInstance(ocspValsEnum.nextElement());
                    }
                    this.ocspVals = ocspValsSeq;
                    break;
                }
                case 2: {
                    this.otherRevVals = OtherRevVals.getInstance(o.getObject());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid tag: " + o.getTagNo());
                }
            }
        }
    }

    public RevocationValues(CertificateList[] crlVals, BasicOCSPResponse[] ocspVals, OtherRevVals otherRevVals) {
        if (crlVals != null) {
            this.crlVals = new DERSequence(crlVals);
        }
        if (ocspVals != null) {
            this.ocspVals = new DERSequence(ocspVals);
        }
        this.otherRevVals = otherRevVals;
    }

    public CertificateList[] getCrlVals() {
        if (this.crlVals == null) {
            return new CertificateList[0];
        }
        CertificateList[] result = new CertificateList[this.crlVals.size()];
        int idx = 0;
        while (idx < result.length) {
            result[idx] = CertificateList.getInstance(this.crlVals.getObjectAt(idx));
            ++idx;
        }
        return result;
    }

    public BasicOCSPResponse[] getOcspVals() {
        if (this.ocspVals == null) {
            return new BasicOCSPResponse[0];
        }
        BasicOCSPResponse[] result = new BasicOCSPResponse[this.ocspVals.size()];
        int idx = 0;
        while (idx < result.length) {
            result[idx] = BasicOCSPResponse.getInstance(this.ocspVals.getObjectAt(idx));
            ++idx;
        }
        return result;
    }

    public OtherRevVals getOtherRevVals() {
        return this.otherRevVals;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.crlVals != null) {
            v.add(new DERTaggedObject(true, 0, this.crlVals));
        }
        if (this.ocspVals != null) {
            v.add(new DERTaggedObject(true, 1, this.ocspVals));
        }
        if (this.otherRevVals != null) {
            v.add(new DERTaggedObject(true, 2, this.otherRevVals.toASN1Primitive()));
        }
        return new DERSequence(v);
    }
}

