/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.ess;

import cn.org.bjca.mssp.msspjce.asn1.ASN1Encodable;
import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1OctetString;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.x509.DigestInfo;
import cn.org.bjca.mssp.msspjce.asn1.x509.IssuerSerial;

public class OtherCertID
extends ASN1Object {
    private ASN1Encodable otherCertHash;
    private IssuerSerial issuerSerial;

    public static OtherCertID getInstance(Object o) {
        if (o instanceof OtherCertID) {
            return (OtherCertID)o;
        }
        if (o != null) {
            return new OtherCertID(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    private OtherCertID(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.otherCertHash = seq.getObjectAt(0).toASN1Primitive() instanceof ASN1OctetString ? ASN1OctetString.getInstance(seq.getObjectAt(0)) : DigestInfo.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.issuerSerial = IssuerSerial.getInstance(seq.getObjectAt(1));
        }
    }

    public OtherCertID(AlgorithmIdentifier algId, byte[] digest) {
        this.otherCertHash = new DigestInfo(algId, digest);
    }

    public OtherCertID(AlgorithmIdentifier algId, byte[] digest, IssuerSerial issuerSerial) {
        this.otherCertHash = new DigestInfo(algId, digest);
        this.issuerSerial = issuerSerial;
    }

    public AlgorithmIdentifier getAlgorithmHash() {
        if (this.otherCertHash.toASN1Primitive() instanceof ASN1OctetString) {
            return new AlgorithmIdentifier("1.3.14.3.2.26");
        }
        return DigestInfo.getInstance(this.otherCertHash).getAlgorithmId();
    }

    public byte[] getCertHash() {
        if (this.otherCertHash.toASN1Primitive() instanceof ASN1OctetString) {
            return ((ASN1OctetString)this.otherCertHash.toASN1Primitive()).getOctets();
        }
        return DigestInfo.getInstance(this.otherCertHash).getDigest();
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.otherCertHash);
        if (this.issuerSerial != null) {
            v.add(this.issuerSerial);
        }
        return new DERSequence(v);
    }
}

