/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.tsp;

import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1OctetString;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DEROctetString;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.asn1.x509.AlgorithmIdentifier;

public class MessageImprint
extends ASN1Object {
    AlgorithmIdentifier hashAlgorithm;
    byte[] hashedMessage;

    public static MessageImprint getInstance(Object o) {
        if (o instanceof MessageImprint) {
            return (MessageImprint)o;
        }
        if (o != null) {
            return new MessageImprint(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    private MessageImprint(ASN1Sequence seq) {
        this.hashAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.hashedMessage = ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets();
    }

    public MessageImprint(AlgorithmIdentifier hashAlgorithm, byte[] hashedMessage) {
        this.hashAlgorithm = hashAlgorithm;
        this.hashedMessage = hashedMessage;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getHashedMessage() {
        return this.hashedMessage;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.hashAlgorithm);
        v.add(new DEROctetString(this.hashedMessage));
        return new DERSequence(v);
    }
}

