/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.asn1.x9;

import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.ASN1OctetString;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import java.util.Enumeration;

public class KeySpecificInfo
extends ASN1Object {
    private ASN1ObjectIdentifier algorithm;
    private ASN1OctetString counter;

    public KeySpecificInfo(ASN1ObjectIdentifier algorithm, ASN1OctetString counter) {
        this.algorithm = algorithm;
        this.counter = counter;
    }

    public KeySpecificInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.algorithm = (ASN1ObjectIdentifier)e.nextElement();
        this.counter = (ASN1OctetString)e.nextElement();
    }

    public ASN1ObjectIdentifier getAlgorithm() {
        return this.algorithm;
    }

    public ASN1OctetString getCounter() {
        return this.counter;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.algorithm);
        v.add(this.counter);
        return new DERSequence(v);
    }
}

