/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.agreement.kdf;

import cn.org.bjca.mssp.msspjce.asn1.ASN1Encodable;
import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.DERNull;
import cn.org.bjca.mssp.msspjce.asn1.DEROctetString;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.asn1.DERTaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.mssp.msspjce.crypto.DataLengthException;
import cn.org.bjca.mssp.msspjce.crypto.DerivationParameters;
import cn.org.bjca.mssp.msspjce.crypto.Digest;
import cn.org.bjca.mssp.msspjce.crypto.DigestDerivationFunction;
import cn.org.bjca.mssp.msspjce.crypto.agreement.kdf.DHKDFParameters;
import cn.org.bjca.mssp.msspjce.crypto.generators.KDF2BytesGenerator;
import cn.org.bjca.mssp.msspjce.crypto.params.KDFParameters;
import cn.org.bjca.mssp.msspjce.crypto.util.Pack;
import java.io.IOException;

public class ECDHKEKGenerator
implements DigestDerivationFunction {
    private DigestDerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        this.kdf = new KDF2BytesGenerator(digest);
    }

    @Override
    public void init(DerivationParameters param) {
        DHKDFParameters params = (DHKDFParameters)param;
        this.algorithm = params.getAlgorithm();
        this.keySize = params.getKeySize();
        this.z = params.getZ();
    }

    @Override
    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new AlgorithmIdentifier(this.algorithm, (ASN1Encodable)DERNull.INSTANCE));
        v.add(new DERTaggedObject(true, 2, new DEROctetString(Pack.intToBigEndian(this.keySize))));
        try {
            this.kdf.init(new KDFParameters(this.z, new DERSequence(v).getEncoded("DER")));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to initialise kdf: " + e.getMessage());
        }
        return this.kdf.generateBytes(out, outOff, len);
    }
}

