/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.ec;

import cn.org.bjca.mssp.msspjce.crypto.CipherParameters;
import cn.org.bjca.mssp.msspjce.crypto.ec.ECEncryptor;
import cn.org.bjca.mssp.msspjce.crypto.ec.ECPair;
import cn.org.bjca.mssp.msspjce.crypto.ec.ECUtil;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ParametersWithRandom;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECElGamalEncryptor
implements ECEncryptor {
    private ECPublicKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p = (ParametersWithRandom)param;
            if (!(p.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)p.getParameters();
            this.random = p.getRandom();
        } else {
            if (!(param instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for encryption.");
            }
            this.key = (ECPublicKeyParameters)param;
            this.random = new SecureRandom();
        }
    }

    @Override
    public ECPair encrypt(ECPoint point) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalEncryptor not initialised");
        }
        BigInteger n = this.key.getParameters().getN();
        BigInteger k = ECUtil.generateK(n, this.random);
        ECPoint g = this.key.getParameters().getG();
        ECPoint gamma = g.multiply(k);
        ECPoint phi = this.key.getQ().multiply(k).add(point);
        return new ECPair(gamma.normalize(), phi.normalize());
    }
}

